<?php $__env->startSection('title', 'Our Services - BlueWeldSG | Cold Welding & Fabrication Experts'); ?>

<?php $__env->startSection('content'); ?>

    <!-- Hero Section -->
    <section class="hero hero-with-image hero-services">
        <div class="hero-background"></div>
        <div class="hero-overlay"></div>
        <div class="hero-container">
            <div class="hero-badge">Our Services</div>
            <h1>Professional Welding &<br>Fabrication Services</h1>
            <p class="hero-subtitle">
                Comprehensive stainless steel solutions for commercial kitchens, from precision cold welding
                to custom fabrication and onsite services across Singapore.
            </p>
        </div>
    </section>

    <!-- Cold Welding Section -->
    <section class="section bg-white" id="cold-welding">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">Signature Service</span>
                <h2 class="section-title">Cold Welding Technology</h2>
                <p class="section-description">
                    Singapore's first and only cold welding service. Our advanced technology allows us to
                    weld ultra-thin stainless steel without heat distortion.
                </p>
            </div>

            <div class="grid grid-2" style="margin-top: 3rem; gap: 2rem;">
                <!-- Left Column - Main Info -->
                <div>
                    <div
                        style="background: linear-gradient(135deg, var(--color-primary) 0%, var(--color-accent) 100%); padding: 2rem; border-radius: 16px; box-shadow: 0 10px 25px rgba(0,0,0,0.1); margin-bottom: 2rem;">
                        <div style="display: flex; align-items: center; gap: 1rem; margin-bottom: 1.5rem;">
                            <div
                                style="width: 56px; height: 56px; background: rgba(255,255,255,0.2); border-radius: 12px; display: flex; align-items: center; justify-content: center; backdrop-filter: blur(10px);">
                                <i class="fas fa-snowflake" style="font-size: 1.5rem; color: white;"></i>
                            </div>
                            <h3 style="color: white; margin: 0; font-size: 1.5rem;">What is Cold Welding?</h3>
                        </div>
                        <p style="color: rgba(255,255,255,0.95); line-height: 1.8; margin-bottom: 1rem;">
                            Cold welding is an innovative joining process that creates strong bonds between metals
                            without applying heat. This revolutionary technique is perfect for delicate stainless
                            steel applications where traditional welding would cause warping or damage.
                        </p>
                        <p style="color: rgba(255,255,255,0.95); line-height: 1.8; margin: 0;">
                            Our cold welding capability extends to stainless steel as thin as <strong
                                style="color: var(--color-accent-light); font-size: 1.125rem;">1mm</strong>,
                            making us the go-to specialists for precision work on hotel kitchen equipment,
                            commercial appliances, and custom fabrications.
                        </p>
                    </div>

                    <!-- Key Benefits -->
                    <div
                        style="background: white; padding: 2rem; border-radius: 16px; box-shadow: 0 10px 25px rgba(0,0,0,0.08); border-left: 4px solid var(--color-accent);">
                        <h4
                            style="color: var(--color-primary-dark); margin-bottom: 1.5rem; font-size: 1.25rem; display: flex; align-items: center; gap: 0.75rem;">
                            <i class="fas fa-star" style="color: var(--color-accent);"></i>
                            Key Benefits
                        </h4>
                        <div style="display: flex; flex-direction: column; gap: 1rem;">
                            <div
                                style="display: flex; align-items: start; gap: 1rem; padding: 1rem; background: rgba(14, 165, 233, 0.05); border-radius: 10px;">
                                <div
                                    style="width: 40px; height: 40px; background: linear-gradient(135deg, #10b981 0%, #059669 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">
                                    <i class="fas fa-fire-extinguisher" style="color: white; font-size: 1.125rem;"></i>
                                </div>
                                <div>
                                    <h5 style="color: var(--color-primary-dark); margin: 0 0 0.25rem 0; font-size: 1rem;">No
                                        Heat Distortion</h5>
                                    <p
                                        style="color: var(--color-text-secondary); margin: 0; font-size: 0.9rem; line-height: 1.5;">
                                        Zero warping or damage to delicate materials</p>
                                </div>
                            </div>
                            <div
                                style="display: flex; align-items: start; gap: 1rem; padding: 1rem; background: rgba(14, 165, 233, 0.05); border-radius: 10px;">
                                <div
                                    style="width: 40px; height: 40px; background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">
                                    <i class="fas fa-ruler-combined" style="color: white; font-size: 1.125rem;"></i>
                                </div>
                                <div>
                                    <h5 style="color: var(--color-primary-dark); margin: 0 0 0.25rem 0; font-size: 1rem;">
                                        Ultra-Thin Materials</h5>
                                    <p
                                        style="color: var(--color-text-secondary); margin: 0; font-size: 0.9rem; line-height: 1.5;">
                                        Perfect for materials as thin as 1mm</p>
                                </div>
                            </div>
                            <div
                                style="display: flex; align-items: start; gap: 1rem; padding: 1rem; background: rgba(14, 165, 233, 0.05); border-radius: 10px;">
                                <div
                                    style="width: 40px; height: 40px; background: linear-gradient(135deg, #8b5cf6 0%, #6d28d9 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">
                                    <i class="fas fa-gem" style="color: white; font-size: 1.125rem;"></i>
                                </div>
                                <div>
                                    <h5 style="color: var(--color-primary-dark); margin: 0 0 0.25rem 0; font-size: 1rem;">
                                        Clean Precision Welds</h5>
                                    <p
                                        style="color: var(--color-text-secondary); margin: 0; font-size: 0.9rem; line-height: 1.5;">
                                        Minimal finishing required for perfect results</p>
                                </div>
                            </div>
                            <div
                                style="display: flex; align-items: start; gap: 1rem; padding: 1rem; background: rgba(14, 165, 233, 0.05); border-radius: 10px;">
                                <div
                                    style="width: 40px; height: 40px; background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">
                                    <i class="fas fa-shield-alt" style="color: white; font-size: 1.125rem;"></i>
                                </div>
                                <div>
                                    <h5 style="color: var(--color-primary-dark); margin: 0 0 0.25rem 0; font-size: 1rem;">
                                        Material Integrity</h5>
                                    <p
                                        style="color: var(--color-text-secondary); margin: 0; font-size: 0.9rem; line-height: 1.5;">
                                        Maintains strength and structural properties</p>
                                </div>
                            </div>
                            <div
                                style="display: flex; align-items: start; gap: 1rem; padding: 1rem; background: rgba(14, 165, 233, 0.05); border-radius: 10px;">
                                <div
                                    style="width: 40px; height: 40px; background: linear-gradient(135deg, #06b6d4 0%, #0891b2 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">
                                    <i class="fas fa-utensils" style="color: white; font-size: 1.125rem;"></i>
                                </div>
                                <div>
                                    <h5 style="color: var(--color-primary-dark); margin: 0 0 0.25rem 0; font-size: 1rem;">
                                        Food-Grade Safe</h5>
                                    <p
                                        style="color: var(--color-text-secondary); margin: 0; font-size: 0.9rem; line-height: 1.5;">
                                        Ideal for food-grade stainless steel applications</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Right Column - Applications -->
                <div>
                    <div
                        style="background: white; padding: 2rem; border-radius: 16px; box-shadow: 0 10px 25px rgba(0,0,0,0.08); border-top: 4px solid #10b981;">
                        <div style="display: flex; align-items: center; gap: 1rem; margin-bottom: 1.5rem;">
                            <div
                                style="width: 56px; height: 56px; background: linear-gradient(135deg, #10b981 0%, #059669 100%); border-radius: 12px; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-clipboard-list" style="font-size: 1.5rem; color: white;"></i>
                            </div>
                            <h4 style="color: var(--color-primary-dark); margin: 0; font-size: 1.5rem;">Applications</h4>
                        </div>

                        <div style="display: flex; flex-direction: column; gap: 1.5rem;">
                            <!-- Kitchen Equipment -->
                            <div
                                style="padding: 1.5rem; background: linear-gradient(135deg, rgba(239, 68, 68, 0.05) 0%, rgba(220, 38, 38, 0.05) 100%); border-radius: 12px; border-left: 4px solid #ef4444;">
                                <div style="display: flex; align-items: center; gap: 0.75rem; margin-bottom: 0.75rem;">
                                    <div
                                        style="width: 40px; height: 40px; background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center;">
                                        <i class="fas fa-fire" style="color: white; font-size: 1.125rem;"></i>
                                    </div>
                                    <h5 style="color: var(--color-primary-dark); margin: 0; font-size: 1.125rem;">Kitchen
                                        Equipment</h5>
                                </div>
                                <p style="color: var(--color-text-secondary); margin: 0; line-height: 1.6;">Repair and
                                    fabrication of commercial kitchen appliances, countertops, and fixtures with precision
                                </p>
                            </div>

                            <!-- Hotel Facilities -->
                            <div
                                style="padding: 1.5rem; background: linear-gradient(135deg, rgba(59, 130, 246, 0.05) 0%, rgba(30, 64, 175, 0.05) 100%); border-radius: 12px; border-left: 4px solid #3b82f6;">
                                <div style="display: flex; align-items: center; gap: 0.75rem; margin-bottom: 0.75rem;">
                                    <div
                                        style="width: 40px; height: 40px; background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center;">
                                        <i class="fas fa-hotel" style="color: white; font-size: 1.125rem;"></i>
                                    </div>
                                    <h5 style="color: var(--color-primary-dark); margin: 0; font-size: 1.125rem;">Hotel
                                        Facilities</h5>
                                </div>
                                <p style="color: var(--color-text-secondary); margin: 0; line-height: 1.6;">Custom solutions
                                    for hotel kitchens, buffet stations, and service areas with premium finish</p>
                            </div>

                            <!-- Precision Repairs -->
                            <div
                                style="padding: 1.5rem; background: linear-gradient(135deg, rgba(245, 158, 11, 0.05) 0%, rgba(217, 119, 6, 0.05) 100%); border-radius: 12px; border-left: 4px solid #f59e0b;">
                                <div style="display: flex; align-items: center; gap: 0.75rem; margin-bottom: 0.75rem;">
                                    <div
                                        style="width: 40px; height: 40px; background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center;">
                                        <i class="fas fa-tools" style="color: white; font-size: 1.125rem;"></i>
                                    </div>
                                    <h5 style="color: var(--color-primary-dark); margin: 0; font-size: 1.125rem;">Precision
                                        Repairs</h5>
                                </div>
                                <p style="color: var(--color-text-secondary); margin: 0; line-height: 1.6;">Delicate repairs
                                    on thin stainless steel components without any damage or distortion</p>
                            </div>
                        </div>

                        <!-- CTA Box -->
                        <div
                            style="margin-top: 2rem; padding: 1.5rem; background: linear-gradient(135deg, var(--color-primary-dark) 0%, var(--color-primary) 100%); border-radius: 12px; text-align: center;">
                            <p style="color: white; margin: 0 0 1rem 0; font-size: 1.125rem; font-weight: 600;">Experience
                                Singapore's Only Cold Welding Service</p>
                            <a href="<?php echo e(route('contact')); ?>"
                                style="display: inline-flex; align-items: center; gap: 0.5rem; padding: 0.875rem 1.75rem; background: white; color: var(--color-primary); border-radius: 8px; text-decoration: none; font-weight: 700; transition: transform 0.2s;">
                                <span>Get a Free Quote</span>
                                <i class="fas fa-arrow-right"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Fabrication Section -->
    <section class="section bg-light" id="fabrication">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">Custom Solutions</span>
                <h2 class="section-title">Stainless Steel Fabrication</h2>
                <p class="section-description">
                    From concept to completion, we create custom stainless steel products tailored to your exact
                    specifications.
                </p>
            </div>

            <div class="grid grid-2">
                <!-- SS Trolleys -->
                <div class="card" style="overflow: hidden;">
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 0.5rem; margin-bottom: 1rem;">
                        <img src="<?php echo e(asset('images/trolley.jpg')); ?>" alt="SS Trolley 1" class="fabrication-image"
                            style="width: 100%; height: 150px; object-fit: cover; border-radius: 8px; cursor: pointer; transition: transform 0.3s;">
                        <img src="<?php echo e(asset('images/trolley-2.jpg')); ?>" alt="SS Trolley 2" class="fabrication-image"
                            style="width: 100%; height: 150px; object-fit: cover; border-radius: 8px; cursor: pointer; transition: transform 0.3s;">
                    </div>
                    <h3 class="card-title">SS Trolleys</h3>
                    <p class="card-text">
                        Custom-built stainless steel trolleys for commercial kitchens. Multiple tiers,
                        various sizes, and configurations to suit your workflow.
                    </p>
                </div>

                <!-- SS Shelving Units -->
                <div class="card" style="overflow: hidden;">
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 0.5rem; margin-bottom: 1rem;">
                        <img src="<?php echo e(asset('images/shelving.jpg')); ?>" alt="SS Shelving 1" class="fabrication-image"
                            style="width: 100%; height: 150px; object-fit: cover; border-radius: 8px; cursor: pointer; transition: transform 0.3s;">
                        <img src="<?php echo e(asset('images/shelving-2.jpg')); ?>" alt="SS Shelving 2" class="fabrication-image"
                            style="width: 100%; height: 150px; object-fit: cover; border-radius: 8px; cursor: pointer; transition: transform 0.3s;">
                    </div>
                    <h3 class="card-title">SS Shelving Units</h3>
                    <p class="card-text">
                        Durable shelving systems designed for heavy-duty commercial use. Adjustable,
                        hygienic, and built to last.
                    </p>
                </div>

                <!-- Work Tables -->
                <div class="card" style="overflow: hidden;">
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 0.5rem; margin-bottom: 1rem;">
                        <img src="<?php echo e(asset('images/work-table-1.jpg')); ?>" alt="Work Table 1" class="fabrication-image"
                            style="width: 100%; height: 150px; object-fit: cover; border-radius: 8px; cursor: pointer; transition: transform 0.3s;">
                        <img src="<?php echo e(asset('images/work-table-2.jpg')); ?>" alt="Work Table 2" class="fabrication-image"
                            style="width: 100%; height: 150px; object-fit: cover; border-radius: 8px; cursor: pointer; transition: transform 0.3s;">
                    </div>
                    <h3 class="card-title">Work Tables</h3>
                    <p class="card-text">
                        Professional-grade stainless steel work tables with integrated storage, sinks,
                        and custom features.
                    </p>
                </div>

                <!-- Custom Enclosures -->
                <div class="card" style="overflow: hidden;">
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 0.5rem; margin-bottom: 1rem;">
                        <img src="<?php echo e(asset('images/hotel-solution.jpg')); ?>" alt="Custom Enclosure 1"
                            class="fabrication-image"
                            style="width: 100%; height: 150px; object-fit: cover; border-radius: 8px; cursor: pointer; transition: transform 0.3s;">
                        <img src="<?php echo e(asset('images/hotel-solution-2.jpg')); ?>" alt="Custom Enclosure 2"
                            class="fabrication-image"
                            style="width: 100%; height: 150px; object-fit: cover; border-radius: 8px; cursor: pointer; transition: transform 0.3s;">
                    </div>
                    <h3 class="card-title">Custom Enclosures</h3>
                    <p class="card-text">
                        Stainless steel cabinets, enclosures, and protective covers for kitchen
                        equipment and utilities.
                    </p>
                </div>

                <!-- Bespoke Solutions -->
                <div class="card" style="overflow: hidden;">
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 0.5rem; margin-bottom: 1rem;">
                        <img src="<?php echo e(asset('images/fabrication-1.jpg')); ?>" alt="Bespoke Solution 1"
                            class="fabrication-image"
                            style="width: 100%; height: 150px; object-fit: cover; border-radius: 8px; cursor: pointer; transition: transform 0.3s;">
                        <img src="<?php echo e(asset('images/fabrication-2.png')); ?>" alt="Bespoke Solution 2"
                            class="fabrication-image"
                            style="width: 100%; height: 150px; object-fit: cover; border-radius: 8px; cursor: pointer; transition: transform 0.3s;">
                    </div>
                    <h3 class="card-title">Bespoke Solutions</h3>
                    <p class="card-text">
                        Unique custom fabrications designed to solve your specific challenges and
                        space requirements.
                    </p>
                </div>

                <!-- Finishing Services -->
                <div class="card" style="overflow: hidden;">
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 0.5rem; margin-bottom: 1rem;">
                        <img src="<?php echo e(asset('images/repairing.jpg')); ?>" alt="Finishing Service 1"
                            class="fabrication-image"
                            style="width: 100%; height: 150px; object-fit: cover; border-radius: 8px; cursor: pointer; transition: transform 0.3s;">
                        <img src="<?php echo e(asset('images/polishing.jpg')); ?>" alt="Finishing Service 2"
                            class="fabrication-image"
                            style="width: 100%; height: 150px; object-fit: cover; border-radius: 8px; cursor: pointer; transition: transform 0.3s;">
                    </div>
                    <h3 class="card-title">Finishing Services</h3>
                    <p class="card-text">
                        Professional finishing including polishing, brushing, and protective coatings
                        for a premium look.
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- Onsite Services Section -->
    <section class="section" id="onsite"
        style="background: linear-gradient(135deg, rgba(30, 58, 138, 0.03) 0%, rgba(14, 165, 233, 0.03) 100%);">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">Mobile Service</span>
                <h2 class="section-title">Onsite Welding Services</h2>
                <p class="section-description">
                    We bring our expertise directly to your location across Singapore. Minimize downtime
                    and maximize convenience with our mobile welding services.
                </p>
            </div>

            <!-- Benefits Grid -->
            <div class="grid grid-3" style="margin-top: 3rem; margin-bottom: 3rem;">
                <div class="card" style="text-align: center; border: 2px solid rgba(14, 165, 233, 0.1);">
                    <div
                        style="width: 64px; height: 64px; background: linear-gradient(135deg, #10b981 0%, #059669 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 1rem;">
                        <i class="fas fa-clock" style="font-size: 1.75rem; color: white;"></i>
                    </div>
                    <h4 style="color: var(--color-primary-dark); margin-bottom: 0.75rem; font-size: 1.125rem;">Minimal
                        Disruption</h4>
                    <p style="color: var(--color-text-secondary); font-size: 0.95rem; line-height: 1.6;">Work continues
                        while we perform repairs or installations</p>
                </div>

                <div class="card" style="text-align: center; border: 2px solid rgba(14, 165, 233, 0.1);">
                    <div
                        style="width: 64px; height: 64px; background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 1rem;">
                        <i class="fas fa-truck" style="font-size: 1.75rem; color: white;"></i>
                    </div>
                    <h4 style="color: var(--color-primary-dark); margin-bottom: 0.75rem; font-size: 1.125rem;">No
                        Transportation</h4>
                    <p style="color: var(--color-text-secondary); font-size: 0.95rem; line-height: 1.6;">Large equipment
                        stays in place, saving time and hassle</p>
                </div>

                <div class="card" style="text-align: center; border: 2px solid rgba(14, 165, 233, 0.1);">
                    <div
                        style="width: 64px; height: 64px; background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 1rem;">
                        <i class="fas fa-bolt" style="font-size: 1.75rem; color: white;"></i>
                    </div>
                    <h4 style="color: var(--color-primary-dark); margin-bottom: 0.75rem; font-size: 1.125rem;">Immediate
                        Solutions</h4>
                    <p style="color: var(--color-text-secondary); font-size: 0.95rem; line-height: 1.6;">Fast response for
                        urgent repairs and emergencies</p>
                </div>

                <div class="card" style="text-align: center; border: 2px solid rgba(14, 165, 233, 0.1);">
                    <div
                        style="width: 64px; height: 64px; background: linear-gradient(135deg, #8b5cf6 0%, #6d28d9 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 1rem;">
                        <i class="fas fa-dollar-sign" style="font-size: 1.75rem; color: white;"></i>
                    </div>
                    <h4 style="color: var(--color-primary-dark); margin-bottom: 0.75rem; font-size: 1.125rem;">
                        Cost-Effective</h4>
                    <p style="color: var(--color-text-secondary); font-size: 0.95rem; line-height: 1.6;">Save on
                        dismantling and transportation costs</p>
                </div>

                <div class="card" style="text-align: center; border: 2px solid rgba(14, 165, 233, 0.1);">
                    <div
                        style="width: 64px; height: 64px; background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 1rem;">
                        <i class="fas fa-toolbox" style="font-size: 1.75rem; color: white;"></i>
                    </div>
                    <h4 style="color: var(--color-primary-dark); margin-bottom: 0.75rem; font-size: 1.125rem;">Professional
                        Setup</h4>
                    <p style="color: var(--color-text-secondary); font-size: 0.95rem; line-height: 1.6;">We bring all
                        necessary equipment and tools</p>
                </div>

                <div class="card" style="text-align: center; border: 2px solid rgba(14, 165, 233, 0.1);">
                    <div
                        style="width: 64px; height: 64px; background: linear-gradient(135deg, #06b6d4 0%, #0891b2 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 1rem;">
                        <i class="fas fa-map-marked-alt" style="font-size: 1.75rem; color: white;"></i>
                    </div>
                    <h4 style="color: var(--color-primary-dark); margin-bottom: 0.75rem; font-size: 1.125rem;">Island-Wide
                        Coverage</h4>
                    <p style="color: var(--color-text-secondary); font-size: 0.95rem; line-height: 1.6;">Serving all areas
                        across Singapore</p>
                </div>
            </div>

            <!-- Services Grid -->
            <div
                style="background: white; border-radius: 16px; padding: 3rem 2rem; box-shadow: 0 4px 6px rgba(0,0,0,0.05);">
                <h3
                    style="text-align: center; color: var(--color-primary-dark); margin-bottom: 2.5rem; font-size: 1.75rem;">
                    Our Onsite Services</h3>
                <div class="grid grid-2" style="gap: 2rem;">
                    <div
                        style="background: rgba(239, 68, 68, 0.05); padding: 1.75rem; border-radius: 12px; box-shadow: 0 2px 4px rgba(0,0,0,0.05); border-left: 4px solid #ef4444;">
                        <div style="display: flex; align-items: flex-start; gap: 1rem;">
                            <div
                                style="width: 48px; height: 48px; background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%); border-radius: 10px; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">
                                <i class="fas fa-exclamation-triangle" style="font-size: 1.25rem; color: white;"></i>
                            </div>
                            <div>
                                <h5 style="color: var(--color-primary-dark); margin-bottom: 0.5rem; font-size: 1.125rem;">
                                    Emergency Repairs</h5>
                                <p
                                    style="color: var(--color-text-secondary); font-size: 0.95rem; line-height: 1.6; margin: 0;">
                                    Quick fixes for broken equipment to get you back in operation fast</p>
                            </div>
                        </div>
                    </div>

                    <div
                        style="background: rgba(59, 130, 246, 0.05); padding: 1.75rem; border-radius: 12px; box-shadow: 0 2px 4px rgba(0,0,0,0.05); border-left: 4px solid #3b82f6;">
                        <div style="display: flex; align-items: flex-start; gap: 1rem;">
                            <div
                                style="width: 48px; height: 48px; background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%); border-radius: 10px; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">
                                <i class="fas fa-wrench" style="font-size: 1.25rem; color: white;"></i>
                            </div>
                            <div>
                                <h5 style="color: var(--color-primary-dark); margin-bottom: 0.5rem; font-size: 1.125rem;">
                                    Installations</h5>
                                <p
                                    style="color: var(--color-text-secondary); font-size: 0.95rem; line-height: 1.6; margin: 0;">
                                    Professional installation of new stainless steel equipment at your site</p>
                            </div>
                        </div>
                    </div>

                    <div
                        style="background: rgba(16, 185, 129, 0.05); padding: 1.75rem; border-radius: 12px; box-shadow: 0 2px 4px rgba(0,0,0,0.05); border-left: 4px solid #10b981;">
                        <div style="display: flex; align-items: flex-start; gap: 1rem;">
                            <div
                                style="width: 48px; height: 48px; background: linear-gradient(135deg, #10b981 0%, #059669 100%); border-radius: 10px; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">
                                <i class="fas fa-cogs" style="font-size: 1.25rem; color: white;"></i>
                            </div>
                            <div>
                                <h5 style="color: var(--color-primary-dark); margin-bottom: 0.5rem; font-size: 1.125rem;">
                                    Modifications</h5>
                                <p
                                    style="color: var(--color-text-secondary); font-size: 0.95rem; line-height: 1.6; margin: 0;">
                                    Adapt existing equipment to new requirements or layouts efficiently</p>
                            </div>
                        </div>
                    </div>

                    <div
                        style="background: rgba(245, 158, 11, 0.05); padding: 1.75rem; border-radius: 12px; box-shadow: 0 2px 4px rgba(0,0,0,0.05); border-left: 4px solid #f59e0b;">
                        <div style="display: flex; align-items: flex-start; gap: 1rem;">
                            <div
                                style="width: 48px; height: 48px; background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); border-radius: 10px; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">
                                <i class="fas fa-search" style="font-size: 1.25rem; color: white;"></i>
                            </div>
                            <div>
                                <h5 style="color: var(--color-primary-dark); margin-bottom: 0.5rem; font-size: 1.125rem;">
                                    Inspections & Maintenance</h5>
                                <p
                                    style="color: var(--color-text-secondary); font-size: 0.95rem; line-height: 1.6; margin: 0;">
                                    Regular maintenance checks and preventive care to avoid breakdowns</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Improvisation Section -->
    <section class="section bg-light" id="improvisation">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">Innovation</span>
                <h2 class="section-title">Improvisation & Custom Solutions</h2>
                <p class="section-description">
                    Every kitchen is unique. We specialize in creating innovative solutions for challenging
                    spaces and specific requirements.
                </p>
            </div>

            <div style="margin-top: 3rem;">
                <!-- Main Content Grid -->
                <div class="grid grid-2" style="gap: 2rem; margin-bottom: 3rem;">
                    <!-- Left Column -->
                    <div>
                        <div
                            style="background: white; padding: 2rem; border-radius: 16px; box-shadow: 0 10px 25px rgba(0,0,0,0.08); border-top: 4px solid var(--color-accent); margin-bottom: 2rem;">
                            <div style="display: flex; align-items: center; gap: 1rem; margin-bottom: 1.5rem;">
                                <div
                                    style="width: 56px; height: 56px; background: linear-gradient(135deg, var(--color-primary) 0%, var(--color-accent) 100%); border-radius: 12px; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-lightbulb" style="font-size: 1.5rem; color: white;"></i>
                                </div>
                                <h3 style="color: var(--color-primary-dark); margin: 0; font-size: 1.5rem;">Tailored to
                                    Your Needs</h3>
                            </div>
                            <p style="color: var(--color-text-secondary); line-height: 1.8; margin-bottom: 1rem;">
                                Standard solutions don't always fit. Our team excels at improvising and creating
                                custom stainless steel solutions that perfectly match your space, workflow, and budget.
                            </p>
                            <p style="color: var(--color-text-secondary); line-height: 1.8; margin: 0;">
                                Whether you need to maximize limited space, integrate with existing equipment, or
                                create something entirely unique, we have the expertise to make it happen.
                            </p>
                        </div>

                        <!-- Process Steps -->
                        <div
                            style="background: linear-gradient(135deg, var(--color-primary-dark) 0%, var(--color-primary) 100%); padding: 2rem; border-radius: 16px; box-shadow: 0 10px 25px rgba(0,0,0,0.1);">
                            <h4
                                style="color: white; margin-bottom: 1.5rem; font-size: 1.25rem; display: flex; align-items: center; gap: 0.75rem;">
                                <i class="fas fa-route" style="font-size: 1.25rem;"></i>
                                Our Process
                            </h4>
                            <div style="display: flex; flex-direction: column; gap: 1rem;">
                                <div style="display: flex; align-items: start; gap: 1rem;">
                                    <div
                                        style="width: 32px; height: 32px; background: rgba(255,255,255,0.2); border-radius: 50%; display: flex; align-items: center; justify-content: center; flex-shrink: 0; font-weight: 700; color: white;">
                                        1</div>
                                    <div>
                                        <h5
                                            style="color: var(--color-accent-light); margin: 0 0 0.25rem 0; font-size: 1rem;">
                                            Consultation</h5>
                                        <p style="color: rgba(255,255,255,0.9); margin: 0; font-size: 0.9rem;">Understand
                                            your requirements and challenges</p>
                                    </div>
                                </div>
                                <div style="display: flex; align-items: start; gap: 1rem;">
                                    <div
                                        style="width: 32px; height: 32px; background: rgba(255,255,255,0.2); border-radius: 50%; display: flex; align-items: center; justify-content: center; flex-shrink: 0; font-weight: 700; color: white;">
                                        2</div>
                                    <div>
                                        <h5
                                            style="color: var(--color-accent-light); margin: 0 0 0.25rem 0; font-size: 1rem;">
                                            Design</h5>
                                        <p style="color: rgba(255,255,255,0.9); margin: 0; font-size: 0.9rem;">Create
                                            custom solutions with your input</p>
                                    </div>
                                </div>
                                <div style="display: flex; align-items: start; gap: 1rem;">
                                    <div
                                        style="width: 32px; height: 32px; background: rgba(255,255,255,0.2); border-radius: 50%; display: flex; align-items: center; justify-content: center; flex-shrink: 0; font-weight: 700; color: white;">
                                        3</div>
                                    <div>
                                        <h5
                                            style="color: var(--color-accent-light); margin: 0 0 0.25rem 0; font-size: 1rem;">
                                            Approval</h5>
                                        <p style="color: rgba(255,255,255,0.9); margin: 0; font-size: 0.9rem;">Review and
                                            refine until perfect</p>
                                    </div>
                                </div>
                                <div style="display: flex; align-items: start; gap: 1rem;">
                                    <div
                                        style="width: 32px; height: 32px; background: rgba(255,255,255,0.2); border-radius: 50%; display: flex; align-items: center; justify-content: center; flex-shrink: 0; font-weight: 700; color: white;">
                                        4</div>
                                    <div>
                                        <h5
                                            style="color: var(--color-accent-light); margin: 0 0 0.25rem 0; font-size: 1rem;">
                                            Fabrication</h5>
                                        <p style="color: rgba(255,255,255,0.9); margin: 0; font-size: 0.9rem;">Precision
                                            manufacturing to specifications</p>
                                    </div>
                                </div>
                                <div style="display: flex; align-items: start; gap: 1rem;">
                                    <div
                                        style="width: 32px; height: 32px; background: rgba(255,255,255,0.2); border-radius: 50%; display: flex; align-items: center; justify-content: center; flex-shrink: 0; font-weight: 700; color: white;">
                                        5</div>
                                    <div>
                                        <h5
                                            style="color: var(--color-accent-light); margin: 0 0 0.25rem 0; font-size: 1rem;">
                                            Installation</h5>
                                        <p style="color: rgba(255,255,255,0.9); margin: 0; font-size: 0.9rem;">Professional
                                            setup and testing</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Right Column -->
                    <div>
                        <!-- Example Projects -->
                        <div
                            style="background: white; padding: 2rem; border-radius: 16px; box-shadow: 0 10px 25px rgba(0,0,0,0.08); margin-bottom: 2rem;">
                            <div style="display: flex; align-items: center; gap: 1rem; margin-bottom: 1.5rem;">
                                <div
                                    style="width: 56px; height: 56px; background: linear-gradient(135deg, #10b981 0%, #059669 100%); border-radius: 12px; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-project-diagram" style="font-size: 1.5rem; color: white;"></i>
                                </div>
                                <h4 style="color: var(--color-primary-dark); margin: 0; font-size: 1.25rem;">Example
                                    Projects</h4>
                            </div>
                            <div style="display: flex; flex-direction: column; gap: 0.875rem;">
                                <div
                                    style="display: flex; align-items: start; gap: 0.75rem; padding: 0.75rem; background: rgba(14, 165, 233, 0.05); border-radius: 8px;">
                                    <i class="fas fa-check-circle"
                                        style="color: #10b981; font-size: 1.125rem; margin-top: 0.125rem;"></i>
                                    <p style="color: var(--color-text-secondary); margin: 0; line-height: 1.6;">
                                        Space-saving corner shelving units for compact kitchens</p>
                                </div>
                                <div
                                    style="display: flex; align-items: start; gap: 0.75rem; padding: 0.75rem; background: rgba(14, 165, 233, 0.05); border-radius: 8px;">
                                    <i class="fas fa-check-circle"
                                        style="color: #10b981; font-size: 1.125rem; margin-top: 0.125rem;"></i>
                                    <p style="color: var(--color-text-secondary); margin: 0; line-height: 1.6;">Custom
                                        trolleys with integrated power outlets</p>
                                </div>
                                <div
                                    style="display: flex; align-items: start; gap: 0.75rem; padding: 0.75rem; background: rgba(14, 165, 233, 0.05); border-radius: 8px;">
                                    <i class="fas fa-check-circle"
                                        style="color: #10b981; font-size: 1.125rem; margin-top: 0.125rem;"></i>
                                    <p style="color: var(--color-text-secondary); margin: 0; line-height: 1.6;">Modified
                                        equipment stands for uneven floors</p>
                                </div>
                                <div
                                    style="display: flex; align-items: start; gap: 0.75rem; padding: 0.75rem; background: rgba(14, 165, 233, 0.05); border-radius: 8px;">
                                    <i class="fas fa-check-circle"
                                        style="color: #10b981; font-size: 1.125rem; margin-top: 0.125rem;"></i>
                                    <p style="color: var(--color-text-secondary); margin: 0; line-height: 1.6;">Hybrid work
                                        tables with specialized features</p>
                                </div>
                                <div
                                    style="display: flex; align-items: start; gap: 0.75rem; padding: 0.75rem; background: rgba(14, 165, 233, 0.05); border-radius: 8px;">
                                    <i class="fas fa-check-circle"
                                        style="color: #10b981; font-size: 1.125rem; margin-top: 0.125rem;"></i>
                                    <p style="color: var(--color-text-secondary); margin: 0; line-height: 1.6;">Retrofit
                                        solutions for legacy equipment</p>
                                </div>
                            </div>
                        </div>

                        <!-- Industries -->
                        <div
                            style="background: linear-gradient(135deg, rgba(59, 130, 246, 0.1) 0%, rgba(14, 165, 233, 0.1) 100%); padding: 2rem; border-radius: 16px; border: 2px solid rgba(59, 130, 246, 0.2);">
                            <div style="display: flex; align-items: center; gap: 1rem; margin-bottom: 1.5rem;">
                                <div
                                    style="width: 48px; height: 48px; background: linear-gradient(135deg, var(--color-primary) 0%, var(--color-accent) 100%); border-radius: 10px; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-building" style="font-size: 1.25rem; color: white;"></i>
                                </div>
                                <h4 style="color: var(--color-primary-dark); margin: 0; font-size: 1.25rem;">Industries We
                                    Serve</h4>
                            </div>
                            <div style="display: grid; grid-template-columns: repeat(2, 1fr); gap: 0.75rem;">
                                <div
                                    style="background: white; padding: 1rem; border-radius: 10px; text-align: center; box-shadow: 0 2px 4px rgba(0,0,0,0.05);">
                                    <i class="fas fa-hotel"
                                        style="color: var(--color-accent); font-size: 1.5rem; margin-bottom: 0.5rem;"></i>
                                    <p
                                        style="margin: 0; color: var(--color-primary); font-weight: 600; font-size: 0.95rem;">
                                        Hotels</p>
                                </div>
                                <div
                                    style="background: white; padding: 1rem; border-radius: 10px; text-align: center; box-shadow: 0 2px 4px rgba(0,0,0,0.05);">
                                    <i class="fas fa-utensils"
                                        style="color: var(--color-accent); font-size: 1.5rem; margin-bottom: 0.5rem;"></i>
                                    <p
                                        style="margin: 0; color: var(--color-primary); font-weight: 600; font-size: 0.95rem;">
                                        Restaurants</p>
                                </div>
                                <div
                                    style="background: white; padding: 1rem; border-radius: 10px; text-align: center; box-shadow: 0 2px 4px rgba(0,0,0,0.05);">
                                    <i class="fas fa-coffee"
                                        style="color: var(--color-accent); font-size: 1.5rem; margin-bottom: 0.5rem;"></i>
                                    <p
                                        style="margin: 0; color: var(--color-primary); font-weight: 600; font-size: 0.95rem;">
                                        Cafes</p>
                                </div>
                                <div
                                    style="background: white; padding: 1rem; border-radius: 10px; text-align: center; box-shadow: 0 2px 4px rgba(0,0,0,0.05);">
                                    <i class="fas fa-concierge-bell"
                                        style="color: var(--color-accent); font-size: 1.5rem; margin-bottom: 0.5rem;"></i>
                                    <p
                                        style="margin: 0; color: var(--color-primary); font-weight: 600; font-size: 0.95rem;">
                                        Catering</p>
                                </div>
                                <div
                                    style="background: white; padding: 1rem; border-radius: 10px; text-align: center; box-shadow: 0 2px 4px rgba(0,0,0,0.05);">
                                    <i class="fas fa-store"
                                        style="color: var(--color-accent); font-size: 1.5rem; margin-bottom: 0.5rem;"></i>
                                    <p
                                        style="margin: 0; color: var(--color-primary); font-weight: 600; font-size: 0.95rem;">
                                        Food Courts</p>
                                </div>
                                <div
                                    style="background: white; padding: 1rem; border-radius: 10px; text-align: center; box-shadow: 0 2px 4px rgba(0,0,0,0.05);">
                                    <i class="fas fa-hospital"
                                        style="color: var(--color-accent); font-size: 1.5rem; margin-bottom: 0.5rem;"></i>
                                    <p
                                        style="margin: 0; color: var(--color-primary); font-weight: 600; font-size: 0.95rem;">
                                        Hospitals</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- CTA Section -->
    <section class="section bg-light">
        <div class="container text-center">
            <h2 class="section-title">Ready to Get Started?</h2>
            <p class="section-description mb-4">
                Contact us today to discuss your project requirements and receive a free, detailed quotation.
            </p>
            <a href="<?php echo e(route('contact')); ?>" class="btn btn-primary">
                Get Free Quotation
                <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                    xmlns="http://www.w3.org/2000/svg">
                    <path d="M7.5 15L12.5 10L7.5 5" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                        stroke-linejoin="round" />
                </svg>
            </a>
        </div>
    </section>

    <!-- Image Lightbox Modal -->
    <div id="imageLightbox"
        style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.95); z-index: 9999; align-items: center; justify-content: center; padding: 2rem;">
        <button id="closeLightbox"
            style="position: absolute; top: 2rem; right: 2rem; background: rgba(255,255,255,0.2); border: none; color: white; font-size: 2rem; width: 50px; height: 50px; border-radius: 50%; cursor: pointer; display: flex; align-items: center; justify-content: center; transition: background 0.3s; backdrop-filter: blur(10px);">
            <i class="fas fa-times"></i>
        </button>
        <img id="lightboxImage" src="" alt=""
            style="max-width: 90%; max-height: 90%; object-fit: contain; border-radius: 8px; box-shadow: 0 20px 60px rgba(0,0,0,0.5);">
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const fabricationImages = document.querySelectorAll('.fabrication-image');
            const lightbox = document.getElementById('imageLightbox');
            const lightboxImage = document.getElementById('lightboxImage');
            const closeLightbox = document.getElementById('closeLightbox');

            // Add hover effect
            fabricationImages.forEach(img => {
                img.addEventListener('mouseenter', function() {
                    this.style.transform = 'scale(1.05)';
                    this.style.boxShadow = '0 8px 16px rgba(0,0,0,0.2)';
                });

                img.addEventListener('mouseleave', function() {
                    this.style.transform = 'scale(1)';
                    this.style.boxShadow = 'none';
                });

                // Click to open lightbox
                img.addEventListener('click', function() {
                    lightboxImage.src = this.src;
                    lightboxImage.alt = this.alt;
                    lightbox.style.display = 'flex';
                    document.body.style.overflow = 'hidden';
                });
            });

            // Close lightbox
            closeLightbox.addEventListener('click', function() {
                lightbox.style.display = 'none';
                document.body.style.overflow = 'auto';
            });

            // Close on background click
            lightbox.addEventListener('click', function(e) {
                if (e.target === lightbox) {
                    lightbox.style.display = 'none';
                    document.body.style.overflow = 'auto';
                }
            });

            // Close on ESC key
            document.addEventListener('keydown', function(e) {
                if (e.key === 'Escape' && lightbox.style.display === 'flex') {
                    lightbox.style.display = 'none';
                    document.body.style.overflow = 'auto';
                }
            });

            // Close button hover effect
            closeLightbox.addEventListener('mouseenter', function() {
                this.style.background = 'rgba(255,255,255,0.3)';
            });

            closeLightbox.addEventListener('mouseleave', function() {
                this.style.background = 'rgba(255,255,255,0.2)';
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.website', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Alphinex Solutions\blueweldsg-royce\resources\views/website/services.blade.php ENDPATH**/ ?>