<?php $__env->startSection('content'); ?>
    <style>
        /* AdminLTE Theme Consistent Colors */
        :root {
            --primary-color: #007bff;
            --primary-dark: #0056b3;
            --primary-light: #66b3ff;
            --secondary-color: #6c757d;
            --success-color: #28a745;
            --info-color: #17a2b8;
            --warning-color: #ffc107;
            --danger-color: #dc3545;
            --dark-color: #343a40;
            --light-color: #f8f9fa;
            --sidebar-bg: #343a40;
            --sidebar-active: #007bff;
        }

        .dashboard-card {
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            border: 1px solid #dee2e6;
            transition: all 0.3s ease;
            overflow: hidden;
            background: #fff;
            height: 100%;
            display: flex;
            flex-direction: column;
            margin-bottom: 20px;
        }

        .dashboard-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15);
            border-color: var(--primary-color);
        }

        .dashboard-card .card-body {
            flex: 1;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }

        .dashboard-card .card-text {
            flex: 1;
            margin-bottom: 15px;
        }

        /* Mobile and Tablet Responsive Spacing */
        @media (max-width: 991.98px) {
            .dashboard-card {
                margin-bottom: 20px;
            }
        }

        @media (max-width: 767.98px) {
            .dashboard-card {
                margin-bottom: 20px;
            }
        }

        @media (max-width: 576px) {
            .dashboard-card {
                margin-bottom: 15px;
            }
        }

        .stat-card {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-dark) 100%);
            color: white;
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 20px;
            position: relative;
            overflow: hidden;
            border: none;
            min-height: 120px;
        }

        .stat-card::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 100px;
            height: 100px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
            transform: translate(30px, -30px);
        }

        .stat-card.users {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-dark) 100%);
        }

        .stat-card.products {
            background: linear-gradient(135deg, var(--success-color) 0%, #20c997 100%);
        }

        .stat-card.alerts {
            background: linear-gradient(135deg, var(--warning-color) 0%, #fd7e14 100%);
        }

        .stat-card.recent {
            background: linear-gradient(135deg, var(--info-color) 0%, #6f42c1 100%);
        }

        .stat-card.sale-returns {
            background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
        }

        .stat-card.return-value {
            background: linear-gradient(135deg, #6f42c1 0%, #5a32a3 100%);
        }

        .stat-card.add-stock {
            background: linear-gradient(135deg, var(--success-color) 0%, #20c997 100%);
        }

        .stat-card.sales {
            background: linear-gradient(135deg, var(--warning-color) 0%, #fd7e14 100%);
        }

        .stat-card.customers {
            background: linear-gradient(135deg, #6f42c1 0%, #5a32a3 100%);
        }

        .stat-icon {
            font-size: 2.5rem;
            opacity: 0.8;
            margin-bottom: 10px;
        }

        .stat-number {
            font-size: 2rem;
            font-weight: bold;
            margin-bottom: 5px;
        }

        .stat-label {
            font-size: 0.85rem;
            opacity: 0.9;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .modern-table {
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            border: 1px solid #dee2e6;
        }

        .modern-table thead {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-dark) 100%) !important;
            color: white !important;
        }

        .modern-table thead th {
            border: none !important;
            padding: 15px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            font-size: 0.85rem;
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-dark) 100%) !important;
            color: white !important;
        }

        .modern-table tbody td {
            padding: 12px 15px;
            border: none;
            border-bottom: 1px solid #f8f9fa;
            vertical-align: middle;
        }

        .modern-table tbody tr:hover {
            background-color: rgba(0, 123, 255, 0.05);
            transition: all 0.2s ease;
        }

        .section-title {
            font-size: 1.5rem;
            font-weight: 600;
            color: var(--dark-color);
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 3px solid var(--primary-color);
            display: inline-block;
        }

        .alert-card {
            border-radius: 8px;
            border: 1px solid #dee2e6;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            background: #fff;
        }

        .alert-card .card-header {
            background: linear-gradient(135deg, var(--warning-color) 0%, #fd7e14 100%);
            border: none;
            color: #fff;
            font-weight: 600;
            border-radius: 8px 8px 0 0;
        }

        .badge-modern {
            padding: 6px 12px;
            border-radius: 4px;
            font-weight: 500;
            font-size: 0.75rem;
        }

        .welcome-section {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-dark) 100%);
            color: white;
            padding: 30px;
            border-radius: 8px;
            margin-bottom: 30px;
            text-align: center;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        .welcome-title {
            font-size: 2rem;
            font-weight: 300;
            margin-bottom: 10px;
        }

        .welcome-subtitle {
            font-size: 1.1rem;
            opacity: 0.9;
        }

        /* Animations */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes pulse {
            0% {
                transform: scale(1);
            }

            50% {
                transform: scale(1.05);
            }

            100% {
                transform: scale(1);
            }
        }

        .stat-card {
            animation: fadeInUp 0.6s ease-out;
        }

        .dashboard-card {
            animation: fadeInUp 0.8s ease-out;
        }

        .welcome-section {
            animation: fadeInUp 0.4s ease-out;
        }

        .stat-card:hover {
            animation: pulse 0.6s ease-in-out;
        }

        /* Responsive improvements */
        @media (max-width: 768px) {
            .stat-card {
                margin-bottom: 15px;
            }

            .stat-number {
                font-size: 2rem;
            }

            .stat-icon {
                font-size: 2.5rem;
            }

            .welcome-title {
                font-size: 1.5rem;
            }

            .dashboard-card {
                margin-bottom: 20px;
            }
        }

        @media (max-width: 576px) {
            .stat-card {
                margin-bottom: 10px;
                padding: 15px;
            }

            .stat-number {
                font-size: 1.5rem;
            }

            .stat-icon {
                font-size: 2rem;
            }

            .stat-label {
                font-size: 0.75rem;
            }

            .dashboard-card {
                margin-bottom: 15px;
            }
        }

        /* Loading states */
        .loading {
            opacity: 0.6;
            pointer-events: none;
        }

        /* Enhanced hover effects */
        .modern-table tbody tr {
            transition: all 0.3s ease;
        }

        .modern-table tbody tr:hover {
            background: linear-gradient(90deg, #f8f9fa 0%, #e9ecef 100%);
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        }

        /* AdminLTE Theme Consistency */
        .card-header {
            border-bottom: 1px solid rgba(255, 255, 255, 0.2);
        }

        .btn {
            border-radius: 4px;
            font-weight: 500;
            transition: all 0.2s ease;
        }

        .btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        .badge {
            border-radius: 4px;
            font-weight: 500;
        }

        /* Consistent spacing */
        .content {
            padding: 20px;
        }

        .card {
            margin-bottom: 20px;
        }

        /* AdminLTE card styling */
        .card-header h5 {
            font-size: 1.1rem;
            font-weight: 600;
        }

        /* Consistent button styling */
        .btn-sm {
            padding: 0.375rem 0.75rem;
            font-size: 0.875rem;
        }

        /* Table responsive improvements */
        .table-responsive {
            border-radius: 0 0 8px 8px;
        }

        /* Alert styling consistency */
        .alert {
            border-radius: 8px;
            border: none;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        .alert-success {
            background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%);
            color: #155724;
        }

        .alert-danger {
            background: linear-gradient(135deg, #f8d7da 0%, #f5c6cb 100%);
            color: #721c24;
        }
    </style>

    <div class="content">
        <!-- Welcome Section -->
        <div class="welcome-section">
            <h1 class="welcome-title">
                <i class="fas fa-tachometer-alt mr-3"></i>
                Welcome to <?php echo e(app_name()); ?>

            </h1>
            <p class="welcome-subtitle">Manage your website, control user access, and keep content up-to-date effortlessly.
            </p>
        </div>

        <?php if(session('status')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="fas fa-check-circle mr-2"></i>
                <?php echo e(session('status')); ?>

                <button type="button" class="close" data-dismiss="alert">
                    <span>&times;</span>
                </button>
            </div>
        <?php endif; ?>

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Alphinex Solutions\blueweldsg-royce\resources\views/home.blade.php ENDPATH**/ ?>