<?php $__env->startSection('title', 'BlueWeldSG - Cold Welding Experts'); ?>

<?php $__env->startSection('content'); ?>
    <style>
        .grid-2 {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 2rem;
        }

        @media (max-width: 768px) {
            .grid-2 {
                grid-template-columns: 1fr;
                /* 1 column on tablets and mobile */
            }
        }
    </style>

    </style>
    
    <section class="hero hero-with-image">
        <div class="hero-background"></div>
        <div class="hero-overlay"></div>
        <div class="hero-container">
            <div class="hero-badge">🔥 Singapore's First Cold Welding Service</div>
            <h1>Precision Welding for<br>Hotel Kitchen Equipment</h1>
            <p class="hero-subtitle">
                Specializing in ultra-thin stainless steel welding (1mm), fabrication, and improvisation.
                Professional onsite services for commercial kitchens across Singapore.
            </p>

            <div class="hero-cta">
                <a href="<?php echo e(route('contact')); ?>" class="btn btn-primary">
                    Get Free Quotation
                </a>

                <a href="<?php echo e(route('services')); ?>" class="btn btn-secondary">
                    Our Services
                </a>
            </div>
        </div>
    </section>

    <!-- About Section -->
    <section class="section bg-white">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">About BlueWeldSG</span>
                <h2 class="section-title">Your Trusted Stainless Steel Specialists</h2>
                <p class="section-description">
                    We are pioneers in cold welding technology in Singapore, offering unmatched precision
                    and quality for hotel kitchen equipment and stainless steel fabrication.
                </p>
            </div>

            <div class="grid grid-2" style="margin-top: 3rem;">
                <div class="card">
                    <div class="card-icon">
                        <svg width="32" height="32" viewBox="0 0 24 24" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path d="M13 2L3 14H12L11 22L21 10H12L13 2Z" stroke="currentColor" stroke-width="2"
                                stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                    </div>
                    <h3 class="card-title">Cold Welding Technology</h3>
                    <p class="card-text">
                        Singapore's first and only cold welding service capable of welding stainless steel
                        as thin as 1mm without heat distortion or warping. Perfect for delicate kitchen equipment.
                    </p>
                </div>

                <div class="card">
                    <div class="card-icon">
                        <svg width="32" height="32" viewBox="0 0 24 24" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M9 11L12 14L22 4M21 12V19C21 19.5304 20.7893 20.0391 20.4142 20.4142C20.0391 20.7893 19.5304 21 19 21H5C4.46957 21 3.96086 20.7893 3.58579 20.4142C3.21071 20.0391 3 19.5304 3 19V5C3 4.46957 3.21071 3.96086 3.58579 3.58579C3.96086 3.21071 4.46957 3 5 3H16"
                                stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                    </div>
                    <h3 class="card-title">Quality Assurance</h3>
                    <p class="card-text">
                        Every project undergoes rigorous quality checks to ensure perfect welds, structural
                        integrity, and compliance with commercial kitchen standards.
                    </p>
                </div>

                <div class="card">
                    <div class="card-icon">
                        <svg width="32" height="32" viewBox="0 0 24 24" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M17 21V19C17 17.9391 16.5786 16.9217 15.8284 16.1716C15.0783 15.4214 14.0609 15 13 15H5C3.93913 15 2.92172 15.4214 2.17157 16.1716C1.42143 16.9217 1 17.9391 1 19V21M23 21V19C22.9993 18.1137 22.7044 17.2528 22.1614 16.5523C21.6184 15.8519 20.8581 15.3516 20 15.13M16 3.13C16.8604 3.3503 17.623 3.8507 18.1676 4.55231C18.7122 5.25392 19.0078 6.11683 19.0078 7.005C19.0078 7.89317 18.7122 8.75608 18.1676 9.45769C17.623 10.1593 16.8604 10.6597 16 10.88M13 7C13 9.20914 11.2091 11 9 11C6.79086 11 5 9.20914 5 7C5 4.79086 6.79086 3 9 3C11.2091 3 13 4.79086 13 7Z"
                                stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                    </div>
                    <h3 class="card-title">Experienced Team</h3>
                    <p class="card-text">
                        Our skilled craftsmen bring years of expertise in stainless steel fabrication,
                        welding, and custom solutions for the hospitality industry.
                    </p>
                </div>

                <div class="card">
                    <div class="card-icon">
                        <svg width="32" height="32" viewBox="0 0 24 24" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22Z"
                                stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M12 6V12L16 14" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" />
                        </svg>
                    </div>
                    <h3 class="card-title">Onsite Services</h3>
                    <p class="card-text">
                        We bring our expertise directly to your location. Minimize downtime with our efficient
                        onsite welding and repair services for commercial kitchens.
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- Why Choose Us Section -->
    <section class="section bg-light">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">Why Choose Us</span>
                <h2 class="section-title">Our Unique Advantages</h2>
            </div>

            <div class="grid grid-2">
                <div class="card">
                    <h4 class="card-title">🎯 Precision Welding</h4>
                    <p class="card-text">
                        Capable of welding stainless steel as thin as 1mm with our advanced cold welding
                        technology - a first in Singapore.
                    </p>
                </div>

                <div class="card">
                    <h4 class="card-title">🏨 Hotel Kitchen Experts</h4>
                    <p class="card-text">
                        Specialized knowledge in commercial kitchen equipment requirements, hygiene standards,
                        and durability needs.
                    </p>
                </div>

                <div class="card">
                    <h4 class="card-title">⚡ Fast Turnaround</h4>
                    <p class="card-text">
                        Quick response times and efficient project completion to minimize disruption to
                        your operations.
                    </p>
                </div>

                <div class="card">
                    <h4 class="card-title">🔧 Custom Solutions</h4>
                    <p class="card-text">
                        Fabrication, improvisation, and custom designs tailored to your specific kitchen
                        layout and requirements.
                    </p>
                </div>

                <div class="card">
                    <h4 class="card-title">💎 Premium Materials</h4>
                    <p class="card-text">
                        We work exclusively with high-grade stainless steel to ensure longevity, hygiene,
                        and aesthetic appeal.
                    </p>
                </div>

                <div class="card">
                    <h4 class="card-title">📍 Onsite Availability</h4>
                    <p class="card-text">
                        Mobile welding services available across Singapore for repairs, installations,
                        and modifications at your location.
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="section bg-light">
        <div class="container text-center">
            <h2 class="section-title">Ready to Get Started?</h2>
            <p class="section-description mb-4">
                Contact us today to discuss your project requirements and receive a free, detailed quotation.
            </p>
            <a href="<?php echo e(route('contact')); ?>" class="btn btn-primary">
                Get Free Quotation
                <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                    xmlns="http://www.w3.org/2000/svg">
                    <path d="M7.5 15L12.5 10L7.5 5" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                        stroke-linejoin="round" />
                </svg>
            </a>
        </div>
    </section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.website', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Alphinex Solutions\blueweldsg-royce\resources\views/website/index.blade.php ENDPATH**/ ?>