<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description"
        content="BlueWeldSG - Singapore's first cold welding service company specializing in hotel kitchen equipment, stainless steel fabrication, and onsite welding services.">
    <meta name="keywords"
        content="cold welding, stainless steel, hotel kitchen equipment, welding singapore, fabrication, onsite welding">
    <title><?php echo $__env->yieldContent('title', 'BlueWeldSG'); ?></title>

    <!-- Favicon -->

    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('images/favicon.png')); ?>?v=<?php echo e(time()); ?>">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Outfit:wght@600;700;800&display=swap"
        rel="stylesheet">
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

    <!-- Bootstrap JS (if using Bootstrap) -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    <!-- Moment.js (needed for datetimepicker) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.4/moment.min.js"></script>

    <!-- Tempus Dominus / Bootstrap Datetimepicker -->
    <script
        src="https://cdnjs.cloudflare.com/ajax/libs/tempusdominus-bootstrap-4/5.39.0/js/tempusdominus-bootstrap-4.min.js">
    </script>

    <!-- Select2 -->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <!-- Styles -->
    <link rel="stylesheet" href="<?php echo e(asset('css/styles.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset('css/whatsapp-button.css')); ?>">
</head>

<body>

    
    <header class="header" id="header">
        <div class="header-container">
            <a href="<?php echo e(url('/')); ?>" class="logo">
                <img src="<?php echo e(url('/images/logo-light.png')); ?>" alt="BlueWeldSG Logo" class="logo-image" width="90"
                    height="auto">
            </a>

            <nav>
                <ul class="nav-menu" id="navMenu">
                    <li><a href="<?php echo e(url('/')); ?>" class="nav-link <?php echo e(request()->is('/') ? 'active' : ''); ?>">Home</a>
                    </li>
                    <li><a href="<?php echo e(route('services')); ?>"
                            class="nav-link <?php echo e(request()->is('services') ? 'active' : ''); ?>">Our Services</a></li>
                    <li><a href="<?php echo e(route('our-works')); ?>"
                            class="nav-link <?php echo e(request()->is('our-works') ? 'active' : ''); ?>">Our Work</a></li>
                    <li><a href="<?php echo e(route('contact')); ?>"
                            class="nav-link <?php echo e(request()->is('contact') ? 'active' : ''); ?>">Contact Us</a></li>
                </ul>
            </nav>

            <button class="mobile-menu-toggle" id="mobileMenuToggle" aria-label="Toggle menu">
                <span></span>
                <span></span>
                <span></span>
            </button>
        </div>
    </header>

    
    <?php echo $__env->yieldContent('content'); ?>

    
    <footer class="footer">
        <div class="container">
            <div class="footer-content">

                <div class="footer-section">
                    <a href="<?php echo e(url('/')); ?>" class="footer-logo" style="display: inline-block;">
                        <img src="<?php echo e(url('/images/logo-light.png')); ?>" alt="BlueWeldSG Logo"
                            style="width: 90px; height: auto;">
                    </a>
                    <p>
                        Singapore's first cold welding service company, specializing in precision welding
                        for hotel kitchen equipment and stainless steel fabrication.
                    </p>
                </div>

                <div class="footer-section">
                    <h3>Quick Links</h3>
                    <ul class="footer-links">
                        <li><a href="<?php echo e(url('/')); ?>"><i class="fas fa-chevron-right"
                                    style="font-size: 0.75rem; margin-right: 0.5rem;"></i>Home</a></li>
                        <li><a href="<?php echo e(route('services')); ?>"><i class="fas fa-chevron-right"
                                    style="font-size: 0.75rem; margin-right: 0.5rem;"></i>Our Services</a></li>
                        <li><a href="<?php echo e(route('our-works')); ?>"><i class="fas fa-chevron-right"
                                    style="font-size: 0.75rem; margin-right: 0.5rem;"></i>Our Work</a></li>
                        <li><a href="<?php echo e(route('contact')); ?>"><i class="fas fa-chevron-right"
                                    style="font-size: 0.75rem; margin-right: 0.5rem;"></i>Contact Us</a></li>
                    </ul>
                </div>

                <div class="footer-section">
                    <h3>Our Services</h3>
                    <ul class="footer-links">
                        <li><a href="<?php echo e(route('services')); ?>#cold-welding"><i class="fas fa-chevron-right"
                                    style="font-size: 0.75rem; margin-right: 0.5rem;"></i>Cold Welding</a></li>
                        <li><a href="<?php echo e(route('services')); ?>#fabrication"><i class="fas fa-chevron-right"
                                    style="font-size: 0.75rem; margin-right: 0.5rem;"></i>Fabrication</a></li>
                        <li><a href="<?php echo e(route('services')); ?>#onsite"><i class="fas fa-chevron-right"
                                    style="font-size: 0.75rem; margin-right: 0.5rem;"></i>Onsite Services</a></li>
                        <li><a href="<?php echo e(route('services')); ?>#improvisation"><i class="fas fa-chevron-right"
                                    style="font-size: 0.75rem; margin-right: 0.5rem;"></i>Custom Solutions</a></li>
                    </ul>
                </div>

                <div class="footer-section">
                    <h3>Contact Info</h3>
                    <ul class="footer-links">
                        <li><i class="fas fa-map-marker-alt"
                                style="margin-right: 0.5rem; color: var(--color-accent);"></i>Singapore</li>
                        <li><i class="fas fa-phone"
                                style="margin-right: 0.5rem; color: var(--color-accent);"></i>Contact for details</li>
                        <li><i class="fas fa-envelope"
                                style="margin-right: 0.5rem; color: var(--color-accent);"></i>info@blueweldsg.com</li>
                        <li><i class="fas fa-clock"
                                style="margin-right: 0.5rem; color: var(--color-accent);"></i>Mon–Sat: 9AM–6PM</li>
                    </ul>
                </div>
            </div>

            <div class="footer-bottom">
                <p>&copy; <?php echo e(date('Y')); ?> BlueWeldSG. All rights reserved. | Singapore's First Cold Welding Service
                </p>
            </div>
        </div>
    </footer>

    <a href="https://wa.me/6591836610" class="whatsapp-float" target="_blank">
        <svg viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg" fill="white">
            <path
                d="M16 0c-8.837 0-16 7.163-16 16 0 2.825 0.737 5.607 2.137 8.048l-2.137 7.952 7.933-2.127c2.42 1.37 5.173 2.127 8.067 2.127 8.837 0 16-7.163 16-16s-7.163-16-16-16zM16 29.467c-2.482 0-4.908-0.646-7.07-1.87l-0.507-0.292-5.247 1.408 1.417-5.267-0.321-0.527c-1.312-2.153-2.005-4.64-2.005-7.185 0-7.384 6.083-13.467 13.467-13.467s13.467 6.083 13.467 13.467-6.083 13.467-13.467 13.467zM21.713 18.429c-0.288-0.144-1.707-0.843-1.971-0.939-0.265-0.096-0.457-0.144-0.649 0.144s-0.745 0.939-0.913 1.131c-0.168 0.192-0.336 0.216-0.624 0.072s-1.217-0.449-2.317-1.429c-0.857-0.764-1.435-1.708-1.603-1.996s-0.018-0.443 0.126-0.587c0.129-0.129 0.288-0.336 0.432-0.504s0.192-0.288 0.288-0.48c0.096-0.192 0.048-0.36-0.024-0.504s-0.649-1.565-0.889-2.141c-0.234-0.561-0.472-0.485-0.649-0.494-0.168-0.008-0.36-0.010-0.553-0.010s-0.505 0.072-0.769 0.36c-0.265 0.288-1.011 0.989-1.011 2.411s1.035 2.797 1.179 2.989c0.144 0.192 2.033 3.104 4.925 4.353 0.688 0.297 1.225 0.474 1.643 0.607 0.691 0.22 1.32 0.189 1.817 0.115 0.554-0.083 1.707-0.698 1.947-1.372s0.24-1.252 0.168-1.372c-0.072-0.12-0.264-0.192-0.552-0.336z" />
        </svg>
    </a>


    
    <script src="<?php echo e(asset('js/main.js')); ?>"></script>
    <?php echo $__env->yieldPushContent('scripts'); ?>

</body>

</html>
<?php /**PATH D:\Alphinex Solutions\blueweldsg-royce\resources\views/layouts/website.blade.php ENDPATH**/ ?>