@extends('layouts.app')

@section('content')
    <style>
        body {
            background: linear-gradient(135deg, #3f87a6, #ebf8e1);
            font-family: 'Poppins', sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }

        .login-card {
            background: #fff;
            border-radius: 16px;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
            width: 400px;
            padding: 2rem;
            transition: all 0.3s ease;
        }

        .login-card:hover {
            transform: translateY(-5px);
        }

        .login-logo img {
            height: 60px;
            margin-bottom: 1rem;
        }

        .login-header {
            text-align: center;
            margin-bottom: 1.5rem;
        }

        .login-header h3 {
            font-weight: 600;
            color: #333;
            margin-top: 0.5rem;
        }

        .form-control {
            border-radius: 10px;
            padding: 0.75rem;
            font-size: 15px;
        }

        .btn-primary {
            border-radius: 10px;
            background: linear-gradient(135deg, #007bff, #00bcd4);
            border: none;
            transition: background 0.3s ease;
        }

        .btn-primary:hover {
            background: linear-gradient(135deg, #0056b3, #0097a7);
        }

        .login-footer {
            text-align: center;
            margin-top: 1rem;
        }

        .login-footer a {
            color: #007bff;
            text-decoration: none;
        }

        .login-footer a:hover {
            text-decoration: underline;
        }

        .input-group-text {
            border-radius: 10px 0 0 10px;
            background: #f0f0f0;
        }

        .form-group {
            position: relative;
        }
    </style>

    <div class="login-card">
        <div class="login-header">
            <div class="login-logo">
                <a href="{{ route('admin.home') }}">
                    {{-- @if (app_logo())
                        <img src="{{ app_logo() }}" alt="{{ app_name() }}">
                    @else
                        <h3>{{ app_name() }}</h3>
                    @endif
                     --}}

                    <img src="{{ url('/images/logo-light.png') }}" alt="BlueWeldSG Logo" class="logo-image" width="90"
                        height="auto">

                </a>
            </div>
            <h3>{{ trans('global.reset_password') }}</h3>
            <p class="text-muted">Enter your new password below to reset your account access.</p>
        </div>

        <form method="POST" action="{{ route('password.request') }}">
            @csrf
            <input type="hidden" name="token" value="{{ $token }}">

            <div class="form-group mb-3">
                <div class="input-group">
                    <span class="input-group-text"><i class="fa fa-envelope"></i></span>
                    <input id="email" type="email"
                        class="form-control{{ $errors->has('email') ? ' is-invalid' : '' }}" name="email"
                        value="{{ $email ?? old('email') }}" required placeholder="{{ trans('global.login_email') }}"
                        autofocus>
                </div>
                @if ($errors->has('email'))
                    <div class="invalid-feedback d-block">{{ $errors->first('email') }}</div>
                @endif
            </div>

            <div class="form-group mb-3">
                <div class="input-group">
                    <span class="input-group-text"><i class="fa fa-lock"></i></span>
                    <input id="password" type="password"
                        class="form-control{{ $errors->has('password') ? ' is-invalid' : '' }}" name="password" required
                        placeholder="{{ trans('global.login_password') }}">
                </div>
                @if ($errors->has('password'))
                    <div class="invalid-feedback d-block">{{ $errors->first('password') }}</div>
                @endif
            </div>

            <div class="form-group mb-4">
                <div class="input-group">
                    <span class="input-group-text"><i class="fa fa-key"></i></span>
                    <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required
                        placeholder="{{ trans('global.login_password_confirmation') }}">
                </div>
            </div>

            <button type="submit" class="btn btn-primary w-100 py-2">
                <i class="fa fa-sync-alt"></i> {{ trans('global.reset_password') }}
            </button>
        </form>

        <div class="login-footer">
            <p class="mt-3 text-muted">
                <a href="{{ route('login') }}">
                    <i class="fa fa-arrow-left"></i> Back to login
                </a>
            </p>
            <p class="text-muted">&copy; {{ date('Y') }} {{ app_name() }}</p>
        </div>
    </div>
@endsection
