@extends('layouts.admin')

@section('content')
    @if (session('message'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle mr-2"></i>
            {{ session('message') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <!-- Enhanced Header Section -->
    <div class="row mb-4">
        <div class="col-lg-8">
            <div class="d-flex align-items-center">
                <div class="mr-3">
                    <i class="fas fa-user-cog text-primary" style="font-size: 2rem;"></i>
                </div>
                <div>
                    <h2 class="mb-0 text-dark font-weight-bold">Profile & Security</h2>
                    <p class="text-muted mb-0">Manage your profile information and account security</p>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Profile Information Card -->
        <div class="col-lg-6 mb-4">
            <div class="card shadow-sm border-0 h-100">
                <div class="card-header bg-white border-0">
                    <div class="d-flex align-items-center">
                        <i class="fas fa-user text-primary mr-2"></i>
                        <h5 class="mb-0 font-weight-bold">{{ trans('global.my_profile') }}</h5>
                    </div>
                </div>
                <div class="card-body">
                    <form method="POST" action="{{ route('admin.profile.password.updateProfile') }}" class="needs-validation"
                        novalidate>
                        @csrf
                        <div class="form-group">
                            <label class="font-weight-bold required" for="name">
                                <i class="fas fa-user mr-1"></i>
                                {{ trans('cruds.user.fields.name') }}
                            </label>
                            <input class="form-control @error('name') is-invalid @enderror" type="text" name="name"
                                id="name" value="{{ old('name', auth()->user()->name) }}"
                                placeholder="Enter your full name" required>
                            @error('name')
                                <div class="invalid-feedback">{{ $errors->first('name') }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label class="font-weight-bold required" for="email">
                                <i class="fas fa-envelope mr-1"></i>
                                {{ trans('cruds.user.fields.email') }}
                            </label>
                            <input class="form-control @error('email') is-invalid @enderror" type="email" name="email"
                                id="email" value="{{ old('email', auth()->user()->email) }}"
                                placeholder="Enter your email address" required>
                            @error('email')
                                <div class="invalid-feedback">{{ $errors->first('email') }}</div>
                            @enderror
                            <small class="form-text text-muted">
                                <i class="fas fa-info-circle mr-1"></i>
                                This email will be used for login and notifications
                            </small>
                        </div>

                        <div class="form-group mb-0">
                            <button class="btn btn-primary btn-lg shadow-sm" type="submit">
                                <i class="fas fa-save mr-2"></i>
                                {{ trans('global.save') }} Profile
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Change Password Card -->
        <div class="col-lg-6 mb-4">
            <div class="card shadow-sm border-0 h-100">
                <div class="card-header bg-white border-0">
                    <div class="d-flex align-items-center">
                        <i class="fas fa-key text-warning mr-2"></i>
                        <h5 class="mb-0 font-weight-bold">{{ trans('global.change_password') }}</h5>
                    </div>
                </div>
                <div class="card-body">
                    <form method="POST" action="{{ route('admin.profile.password.update') }}" class="needs-validation"
                        novalidate>
                        @csrf
                        <div class="form-group">
                            <label class="font-weight-bold required" for="password">
                                <i class="fas fa-lock mr-1"></i>
                                New {{ trans('cruds.user.fields.password') }}
                            </label>
                            <input class="form-control @error('password') is-invalid @enderror" type="password"
                                name="password" id="password" placeholder="Enter new password" required>
                            @error('password')
                                <div class="invalid-feedback">{{ $errors->first('password') }}</div>
                            @enderror
                            <small class="form-text text-muted">
                                <i class="fas fa-shield-alt mr-1"></i>
                                Password must be at least 8 characters long
                            </small>
                        </div>

                        <div class="form-group">
                            <label class="font-weight-bold required" for="password_confirmation">
                                <i class="fas fa-lock mr-1"></i>
                                Confirm New {{ trans('cruds.user.fields.password') }}
                            </label>
                            <input class="form-control @error('password_confirmation') is-invalid @enderror" type="password"
                                name="password_confirmation" id="password_confirmation" placeholder="Confirm new password"
                                required>
                            @error('password_confirmation')
                                <div class="invalid-feedback">{{ $errors->first('password_confirmation') }}</div>
                            @enderror
                        </div>

                        <div class="form-group mb-0">
                            <button class="btn btn-warning btn-lg shadow-sm" type="submit">
                                <i class="fas fa-key mr-2"></i>
                                {{ trans('global.save') }} Password
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Danger Zone -->
    <div class="row">
        <div class="col-12">
            <div class="card shadow-sm border-danger">
                <div class="card-header bg-danger text-white border-0">
                    <div class="d-flex align-items-center">
                        <i class="fas fa-exclamation-triangle mr-2"></i>
                        <h5 class="mb-0 font-weight-bold">Danger Zone</h5>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col-md-8">
                            <h6 class="font-weight-bold text-danger mb-1">{{ trans('global.delete_account') }}</h6>
                            <p class="text-muted mb-0">
                                <i class="fas fa-info-circle mr-1"></i>
                                Once you delete your account, there is no going back. Please be certain.
                            </p>
                        </div>
                        <div class="col-md-4 text-right">
                            <form method="POST" action="{{ route('admin.profile.password.destroyProfile') }}"
                                onsubmit="return confirmDeleteAccount()" class="d-inline">
                                @csrf
                                <button class="btn btn-outline-danger btn-lg shadow-sm" type="submit">
                                    <i class="fas fa-trash mr-2"></i>
                                    {{ trans('global.delete') }} Account
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('styles')
    <style>
        .form-control:focus {
            border-color: #007bff;
            box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
        }

        .card {
            border-radius: 10px;
        }

        .card-header {
            border-radius: 10px 10px 0 0 !important;
        }

        .border-danger {
            border-color: #dc3545 !important;
        }

        .btn-outline-danger:hover {
            background-color: #dc3545;
            border-color: #dc3545;
        }
    </style>
@endsection

@section('scripts')
    <script>
        // Form validation
        (function() {
            'use strict';
            window.addEventListener('load', function() {
                var forms = document.getElementsByClassName('needs-validation');
                var validation = Array.prototype.filter.call(forms, function(form) {
                    form.addEventListener('submit', function(event) {
                        if (form.checkValidity() === false) {
                            event.preventDefault();
                            event.stopPropagation();
                        }
                        form.classList.add('was-validated');
                    }, false);
                });
            }, false);
        })();

        // Password confirmation validation
        document.getElementById('password_confirmation').addEventListener('input', function() {
            const password = document.getElementById('password').value;
            const confirmPassword = this.value;

            if (password !== confirmPassword) {
                this.setCustomValidity('Passwords do not match');
            } else {
                this.setCustomValidity('');
            }
        });

        // Account deletion confirmation
        function confirmDeleteAccount() {
            const userEmail = '{{ auth()->user()->email }}';
            const confirmation = prompt(
            '{{ __('global.delete_account_warning') }}\n\nType your email address to confirm:');

            if (confirmation === userEmail) {
                return confirm('Are you absolutely sure you want to delete your account? This action cannot be undone.');
            } else {
                alert('Email address does not match. Account deletion cancelled.');
                return false;
            }
        }
    </script>
@endsection
