@extends('layouts.app')

@section('content')
    <style>
        body {
            background: linear-gradient(135deg, #3f87a6, #ebf8e1);
            font-family: 'Poppins', sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }

        .login-card {
            background: #fff;
            border-radius: 16px;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
            width: 400px;
            padding: 2rem;
            transition: all 0.3s ease;
        }

        .login-card:hover {
            transform: translateY(-5px);
        }

        .login-logo img {
            height: 60px;
            margin-bottom: 1rem;
        }

        .login-header {
            text-align: center;
            margin-bottom: 1.5rem;
        }

        .login-header h3 {
            font-weight: 600;
            color: #333;
            margin-top: 0.5rem;
        }

        .form-control {
            border-radius: 10px;
            padding: 0.75rem;
            font-size: 15px;
        }

        .btn-primary {
            border-radius: 10px;
            background: linear-gradient(135deg, #007bff, #00bcd4);
            border: none;
            transition: background 0.3s ease;
        }

        .btn-primary:hover {
            background: linear-gradient(135deg, #0056b3, #0097a7);
        }

        .login-footer {
            text-align: center;
            margin-top: 1rem;
        }

        .login-footer a {
            color: #007bff;
            text-decoration: none;
        }

        .login-footer a:hover {
            text-decoration: underline;
        }

        .input-group-text {
            border-radius: 10px 0 0 10px;
            background: #f0f0f0;
        }

        .form-group {
            position: relative;
        }
    </style>

    <div class="login-card">
        <div class="login-header">
            <div class="login-logo">
                <a href="{{ route('admin.home') }}">
                    {{-- @if (app_logo())
                        <img src="{{ app_logo() }}" alt="{{ app_name() }}">
                    @else
                        <h3>{{ app_name() }}</h3>
                    @endif --}}
                    <img src="{{ url('/images/logo-light.png') }}" alt="BlueWeldSG Logo" class="logo-image" width="90"
                        height="auto">

                </a>
            </div>
            <h3>{{ trans('global.login') }}</h3>
            <p class="text-muted">Welcome back! Please login to continue.</p>
        </div>

        @if (session()->has('message'))
            <div class="alert alert-info text-center">{{ session()->get('message') }}</div>
        @endif

        <form method="POST" action="{{ route('login') }}">
            @csrf

            <div class="form-group mb-3">
                <div class="input-group">
                    <span class="input-group-text"><i class="fa fa-envelope"></i></span>
                    <input id="email" type="email" name="email" placeholder="{{ trans('global.login_email') }}"
                        class="form-control{{ $errors->has('email') ? ' is-invalid' : '' }}"
                        value="{{ old('email') ?? 'superadmin@admin.com' }}" required autofocus>
                </div>
                @if ($errors->has('email'))
                    <div class="invalid-feedback d-block">{{ $errors->first('email') }}</div>
                @endif
            </div>

            <div class="form-group mb-3">
                <div class="input-group">
                    <span class="input-group-text"><i class="fa fa-lock"></i></span>
                    <input id="password" type="password" name="password" placeholder="{{ trans('global.login_password') }}"
                        class="form-control{{ $errors->has('password') ? ' is-invalid' : '' }}" required value="password">
                </div>
                @if ($errors->has('password'))
                    <div class="invalid-feedback d-block">{{ $errors->first('password') }}</div>
                @endif
            </div>

            <div class="d-flex justify-content-between align-items-center mb-3">
                <div>
                    <input type="checkbox" name="remember" id="remember">
                    <label for="remember" class="text-muted">{{ trans('global.remember_me') }}</label>
                </div>
                @if (Route::has('password.request'))
                    <a href="{{ route('password.request') }}" class="small text-muted">
                        {{ trans('global.forgot_password') }}?
                    </a>
                @endif
            </div>

            <button type="submit" class="btn btn-primary w-100 py-2">
                <i class="fa fa-sign-in-alt"></i> {{ trans('global.login') }}
            </button>
        </form>

        <div class="login-footer">
            <p class="mt-3 text-muted">&copy; {{ date('Y') }} {{ app_name() }}</p>
        </div>
    </div>
@endsection
