@extends('layouts.admin')
@section('content')
    <!-- Enhanced Header Section -->
    <div class="row mb-4">
        <div class="col-lg-8">
            <div class="d-flex align-items-center">
                <div class="mr-3">
                    <i class="fas fa-video text-primary" style="font-size: 2rem;"></i>
                </div>
                <div>
                    <h2 class="mb-0 text-dark font-weight-bold">Videos Gallery</h2>
                    <p class="text-muted mb-0">Manage your video content</p>
                </div>
            </div>
        </div>
        <div class="col-lg-4 text-right">
            <a class="btn btn-primary btn-lg shadow-sm" href="{{ route('admin.videos.create') }}">
                <i class="fas fa-plus mr-2"></i>Add Video
            </a>
        </div>
    </div>

    @if ($videos->count() > 0)
        <!-- Video Cards Grid -->
        <div class="row">
            @foreach ($videos as $video)
                <div class="col-md-6 col-lg-4 mb-4">
                    <div class="card shadow-sm border-0 h-100 video-card-item">
                        <!-- Video Preview -->
                        <div class="video-preview-wrapper"
                            style="position: relative; background: #000; padding-top: 56.25%;">
                            @if ($video->video_type === 'upload')
                                <video controls
                                    style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; object-fit: cover;">
                                    <source src="{{ $video->embed_url }}" type="video/mp4">
                                    Your browser does not support the video tag.
                                </video>
                            @else
                                <iframe src="{{ $video->embed_url }}"
                                    style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; border: 0;"
                                    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                                    allowfullscreen>
                                </iframe>
                            @endif
                        </div>

                        <!-- Card Body -->
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-start mb-2">
                                <h5 class="card-title mb-0 flex-grow-1" style="font-size: 1.1rem;">
                                    {{ $video->title ?: 'Untitled Video' }}
                                </h5>
                                <span class="badge badge-secondary ml-2">
                                    <i class="fas fa-sort-numeric-down mr-1"></i>
                                    Order: {{ $video->sort_order }}
                                </span>
                                @if ($video->video_type === 'upload')
                                    <span class="badge badge-success ml-2">
                                        <i class="fas fa-upload mr-1"></i>Uploaded
                                    </span>
                                @else
                                    <span class="badge badge-info ml-2">
                                        <i class="fas fa-link mr-1"></i>Link
                                    </span>
                                @endif
                            </div>

                            <p class="text-muted small mb-3">
                                <sorted by="sort_order">{{ $video->sort_order }}</sorted>
                                @if ($video->video_type === 'upload')
                                    <i class="fas fa-file-video mr-1"></i>{{ basename($video->video_path) }}
                                @else
                                    <i class="fas fa-external-link-alt mr-1"></i>
                                    <span class="text-truncate d-inline-block"
                                        style="max-width: 200px; vertical-align: bottom;">
                                        {{ $video->url }}
                                    </span>
                                @endif
                            </p>

                            <!-- Action Buttons -->
                            <div class="d-flex justify-content-between">
                                <a href="{{ route('admin.videos.edit', $video->id) }}"
                                    class="btn btn-sm btn-outline-primary flex-fill mr-2">
                                    <i class="fas fa-edit mr-1"></i>Edit
                                </a>
                                <form action="{{ route('admin.videos.destroy', $video->id) }}" method="POST"
                                    onsubmit="return confirm('{{ trans('global.areYouSure') }}');" class="flex-fill">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-outline-danger w-100">
                                        <i class="fas fa-trash mr-1"></i>Delete
                                    </button>
                                </form>
                            </div>
                        </div>

                        <!-- Card Footer -->
                        <div class="card-footer bg-light border-0">
                            <small class="text-muted">
                                <i class="far fa-clock mr-1"></i>
                                Updated {{ $video->updated_at->diffForHumans() }}
                            </small>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    @else
        <!-- Empty State -->
        <div class="card shadow-sm border-0">
            <div class="card-body text-center py-5">
                <div style="font-size: 4rem; color: #cbd5e0; margin-bottom: 1rem;">
                    <i class="fas fa-video"></i>
                </div>
                <h4 class="text-muted mb-3">No videos yet</h4>
                <p class="text-muted mb-4">Start building your video gallery by adding your first video.</p>
                <a href="{{ route('admin.videos.create') }}" class="btn btn-primary btn-lg">
                    <i class="fas fa-plus mr-2"></i>Add Your First Video
                </a>
            </div>
        </div>
    @endif
@endsection

@section('styles')
    <style>
        .video-card-item {
            transition: transform 0.2s, box-shadow 0.2s;
        }

        .video-card-item:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1) !important;
        }

        .video-preview-wrapper {
            overflow: hidden;
            border-radius: 0.25rem 0.25rem 0 0;
        }
    </style>
@endsection

@section('scripts')
    @parent
    <script>
        // Show success message if exists
        @if (session('message'))
            toastr.success('{{ session('message') }}');
        @endif
    </script>
@endsection
