@extends('layouts.admin')
@section('content')
    <!-- Enhanced Header Section -->
    <div class="row mb-4">
        <div class="col-lg-8">
            <div class="d-flex align-items-center">
                <div class="mr-3">
                    <i class="fas fa-user text-info" style="font-size: 2rem;"></i>
                </div>
                <div>
                    <h2 class="mb-0 text-dark font-weight-bold">{{ trans('global.show') }} {{ trans('cruds.user.title') }}
                    </h2>
                    <p class="text-muted mb-0">View user details and information</p>
                </div>
            </div>
        </div>
        <div class="col-lg-4 text-right">
            <div class="btn-group" role="group">
                <a href="{{ route('admin.users.index') }}" class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-left mr-2"></i>{{ trans('global.back_to_list') }}
                </a>
                @can('user_edit')
                    <a href="{{ route('admin.users.edit', $user->id) }}" class="btn btn-primary">
                        <i class="fas fa-edit mr-2"></i>Edit
                    </a>
                @endcan
            </div>
        </div>
    </div>

    <!-- Enhanced Card Design -->
    <div class="card shadow-sm border-0">
        <div class="card-header bg-white border-0">
            <div class="d-flex align-items-center">
                <i class="fas fa-user text-primary mr-2"></i>
                <h5 class="mb-0 font-weight-bold">User Details</h5>
            </div>
        </div>

        <div class="card-body">
            <div class="row">
                <div class="col-lg-8">
                    <table class="table table-borderless mb-0">
                        <tbody>
                            <tr>
                                <th class="text-muted font-weight-bold" style="width: 200px;">
                                    <i class="fas fa-hashtag mr-2"></i>{{ trans('cruds.user.fields.id') }}
                                </th>
                                <td>
                                    <span class="badge badge-secondary">{{ $user->id }}</span>
                                </td>
                            </tr>
                            <tr>
                                <th class="text-muted font-weight-bold">
                                    <i class="fas fa-user mr-2"></i>{{ trans('cruds.user.fields.name') }}
                                </th>
                                <td>
                                    <strong>{{ $user->name }}</strong>
                                </td>
                            </tr>
                            <tr>
                                <th class="text-muted font-weight-bold">
                                    <i class="fas fa-envelope mr-2"></i>{{ trans('cruds.user.fields.email') }}
                                </th>
                                <td>
                                    <a href="mailto:{{ $user->email }}" class="text-primary">{{ $user->email }}</a>
                                </td>
                            </tr>
                            <tr>
                                <th class="text-muted font-weight-bold">
                                    <i class="fas fa-user-tag mr-2"></i>{{ trans('cruds.user.fields.roles') }}
                                </th>
                                <td>
                                    @if ($user->roles && $user->roles->count() > 0)
                                        @foreach ($user->roles as $role)
                                            <span class="badge badge-primary px-3 py-2 mb-1 shadow-sm"
                                                style="font-size: 0.85rem; border-radius: 10px;">
                                                <i class="fas fa-shield-alt mr-1"></i> {{ $role->title }}
                                            </span>
                                        @endforeach
                                    @else
                                        <span class="text-muted">—</span>
                                    @endif
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <div class="col-lg-4">
                    <div class="card bg-light">
                        <div class="card-body text-center">
                            <div class="mb-3">
                                <i class="fas fa-user-circle text-primary" style="font-size: 4rem;"></i>
                            </div>
                            <h5 class="card-title">{{ $user->name }}</h5>
                            <p class="card-text text-muted">{{ $user->email }}</p>
                            <hr>
                            <div class="row text-center">
                                <div class="col-12">
                                    <h6 class="text-muted">User ID</h6>
                                    <h5 class="text-primary">#{{ $user->id }}</h5>
                                </div>
                            </div>
                            @if ($user->roles && $user->roles->count() > 0)
                                <hr>
                                <div class="text-center">
                                    <h6 class="text-muted mb-2">Assigned Role{{ $user->roles->count() > 1 ? 's' : '' }}
                                    </h6>
                                    @foreach ($user->roles as $role)
                                        <span class="badge badge-primary px-3 py-2 shadow-sm"
                                            style="font-size: 0.85rem; border-radius: 10px;">
                                            {{ $role->title }}
                                        </span>
                                    @endforeach
                                </div>
                            @endif
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
