@extends('layouts.admin')
@section('content')
    <!-- Enhanced Header Section -->
    <div class="row mb-4">
        <div class="col-lg-8">
            <div class="d-flex align-items-center">
                <div class="mr-3">
                    <i class="fas fa-users text-primary" style="font-size: 2rem;"></i>
                </div>
                <div>
                    <h2 class="mb-0 text-dark font-weight-bold">{{ trans('cruds.user.title_singular') }}
                        {{ trans('global.list') }}</h2>
                    <p class="text-muted mb-0">Total Users: {{ $users->count() }}</p>
                </div>
            </div>
        </div>
        <div class="col-lg-4 text-right">
            @can('user_create')
                <a class="btn btn-primary btn-lg shadow-sm" href="{{ route('admin.users.create') }}">
                    <i class="fas fa-user-plus mr-2"></i>
                    {{ trans('global.add') }} {{ trans('cruds.user.title_singular') }}
                </a>
            @endcan
        </div>
    </div>

    <!-- Enhanced Card with Modern Design -->
    <div class="card shadow-sm border-0">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover datatable datatable-User">
                    <thead>
                        <tr>
                            <th width="10"></th>
                            <th>S.No</th>
                            <th>{{ trans('cruds.user.fields.name') }}</th>
                            <th>{{ trans('cruds.user.fields.email') }}</th>
                            <th>Role</th> {{-- ✅ Added Role column --}}
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($users as $key => $user)
                            <tr data-entry-id="{{ $user->id }}">
                                <td></td>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $user->name ?? '' }}</td>
                                <td>{{ $user->email ?? '' }}</td>
                                <td>
                                    @if ($user->roles && $user->roles->count())
                                        @foreach ($user->roles as $role)
                                            <span class="badge bg-primary">{{ $role->title }}</span>
                                        @endforeach
                                    @else
                                        <span class="text-muted">—</span>
                                    @endif
                                </td>

                                <td>
                                    <div class="action-buttons">
                                        @can('user_show')
                                            <a class="action-btn action-btn-view"
                                                href="{{ route('admin.users.show', $user->id) }}" title="View User">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                        @endcan

                                        @can('user_edit')
                                            <a class="action-btn action-btn-edit"
                                                href="{{ route('admin.users.edit', $user->id) }}" title="Edit User">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                        @endcan

                                        @can('user_delete')
                                            <button type="button" class="action-btn action-btn-delete"
                                                data-delete-url="{{ route('admin.users.destroy', $user->id) }}"
                                                data-delete-message="Are you sure you want to delete this user? This will also delete all related records and cannot be undone."
                                                title="Delete User">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        @endcan
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    @include('partials.deleteConfirmationModal')
@endsection

@section('scripts')
    @parent
    <script src="{{ asset('js/deleteConfirmationModal.js') }}"></script>
    <script>
        $(function() {
            let dtButtons = $.extend(true, [], $.fn.dataTable.defaults.buttons)
            @can('user_delete')
                let deleteButton = {
                    text: '{{ trans('global.datatables.delete') }}',
                    url: "{{ route('admin.users.massDestroy') }}",
                    className: 'btn-danger',
                    action: function(e, dt, node, config) {
                        var ids = $.map(dt.rows({
                            selected: true
                        }).nodes(), function(entry) {
                            return $(entry).data('entry-id')
                        });

                        if (ids.length === 0) {
                            alert('{{ trans('global.datatables.zero_selected') }}')
                            return
                        }

                        if (confirm('{{ trans('global.areYouSure') }}')) {
                            $.ajax({
                                headers: {
                                    'x-csrf-token': _token
                                },
                                method: 'POST',
                                url: config.url,
                                data: {
                                    ids: ids,
                                    _method: 'DELETE'
                                }
                            }).done(function() {
                                location.reload()
                            })
                        }
                    }
                }
                dtButtons.push(deleteButton)
            @endcan

            $.extend(true, $.fn.dataTable.defaults, {
                orderCellsTop: true,
                pageLength: 100,
            });
            let table = $('.datatable-User:not(.ajaxTable)').DataTable({
                buttons: dtButtons
            })
            $('a[data-toggle="tab"]').on('shown.bs.tab click', function() {
                $($.fn.dataTable.tables(true)).DataTable().columns.adjust();
            });
        })
    </script>
@endsection
