@extends('layouts.admin')
@section('content')
    <!-- Enhanced Header Section -->
    <div class="row mb-4">
        <div class="col-lg-8">
            <div class="d-flex align-items-center">
                <div class="mr-3">
                    <i class="fas fa-user-plus text-success" style="font-size: 2rem;"></i>
                </div>
                <div>
                    <h2 class="mb-0 text-dark font-weight-bold">{{ trans('global.create') }}
                        {{ trans('cruds.user.title_singular') }}</h2>
                    <p class="text-muted mb-0">Add a new user to the system</p>
                </div>
            </div>
        </div>
        <div class="col-lg-4 text-right">
            <a href="{{ route('admin.users.index') }}" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left mr-2"></i>Back to Users
            </a>
        </div>
    </div>

    <!-- Enhanced Card Design -->
    <div class="card shadow-sm border-0">
        <div class="card-header bg-white border-0">
            <div class="d-flex align-items-center">
                <i class="fas fa-user text-primary mr-2"></i>
                <h5 class="mb-0 font-weight-bold">User Information</h5>
            </div>
        </div>

        <div class="card-body">
            <form method="POST"
                action="{{ isset($user) ? route('admin.users.update', $user->id) : route('admin.users.store') }}"
                enctype="multipart/form-data" class="needs-validation" novalidate>
                @csrf
                @if (isset($user))
                    @method('PUT')
                @endif

                @php
                    $isEdit = isset($user);
                    $fields = [
                        'name' => ['Name', 'text', trans('cruds.user.fields.name_helper'), true],
                        'email' => ['Email', 'email', trans('cruds.user.fields.email_helper'), true],
                        'password' => ['Password', 'password', trans('cruds.user.fields.password_helper'), !$isEdit], // required only if creating
                        'password_confirmation' => [
                            'Confirm Password',
                            'password',
                            'Re-enter the password for confirmation',
                            !$isEdit,
                        ], // same
                        'role_id' => ['Role', 'select', '', true],
                    ];
                @endphp
                <div class="row">
                    @foreach ($fields as $field => $meta)
                        <div class="col-12 col-md-6 mb-2">
                            <div class="form-group {{ $errors->has($field) ? 'has-error' : '' }}">
                                <label @if (!empty($meta[3])) class="required" @endif
                                    for="{{ $field }}">{{ $meta[0] }}</label>

                                @if (in_array($field, ['password', 'password_confirmation']))
                                    <div class="input-group position-relative">
                                        <input class="form-control {{ $errors->has($field) ? 'is-invalid' : '' }}"
                                            type="password" name="{{ $field }}" id="{{ $field }}"
                                            @if ($meta[3]) required @endif
                                            placeholder="{{ $isEdit ? 'Leave blank to keep current password' : '' }}">
                                        <div class="input-group-append">
                                            <button class="btn btn-outline-secondary toggle-password" type="button"
                                                data-target="#{{ $field }}">
                                                <i class="fas fa-eye"></i>
                                            </button>
                                        </div>
                                    </div>
                                    @if ($errors->has($field))
                                        <span class="text-danger">{{ $errors->first($field) }}</span>
                                    @endif
                                    <span class="help-block">{{ $meta[2] }}</span>
                                @elseif($field === 'role_id')
                                    <select name="role_id" id="role_id" class="form-control" required>
                                        @foreach ($roles as $role)
                                            <option value="{{ $role->id }}"
                                                {{ old('role_id', data_get($user ?? null, 'role_id', '')) == $role->id ? 'selected' : '' }}>
                                                {{ $role->title }}
                                            </option>
                                        @endforeach
                                    </select>
                                @else
                                    <input class="form-control {{ $errors->has($field) ? 'is-invalid' : '' }}"
                                        type="{{ $meta[1] }}" name="{{ $field }}" id="{{ $field }}"
                                        value="{{ old($field, data_get($user ?? null, $field, '')) }}"
                                        @if (!empty($meta[3])) required @endif>
                                    @if ($errors->has($field))
                                        <span class="text-danger">{{ $errors->first($field) }}</span>
                                    @endif
                                    <span class="help-block">{{ $meta[2] }}</span>
                                @endif
                            </div>
                        </div>
                    @endforeach
                </div>

                <!-- Form Actions -->
                <div class="form-group mt-4 pt-3 border-top">
                    <div class="d-flex justify-content-between flex-wrap">
                        <a href="{{ route('admin.users.index') }}" class="btn btn-outline-secondary btn-lg shadow-sm mb-2">
                            <i class="fas fa-times mr-2"></i>Cancel
                        </a>
                        <button class="btn btn-primary btn-lg shadow-sm mb-2" type="submit">
                            <i
                                class="fas fa-save mr-2"></i>{{ isset($user) ? trans('global.update') : trans('global.save') }}
                        </button>
                    </div>
                </div>
            </form>
        </div>

    </div>

    <!-- Enhanced JavaScript for Form Validation and Password Toggle -->
    <script>
        // Bootstrap form validation
        (function() {
            'use strict';
            window.addEventListener('load', function() {
                var forms = document.getElementsByClassName('needs-validation');
                Array.prototype.filter.call(forms, function(form) {
                    form.addEventListener('submit', function(event) {
                        if (form.checkValidity() === false) {
                            event.preventDefault();
                            event.stopPropagation();
                        }
                        form.classList.add('was-validated');
                    }, false);
                });
            }, false);
        })();

        // Password visibility toggle
        document.querySelectorAll('.toggle-password').forEach(button => {
            button.addEventListener('click', function() {
                const target = document.querySelector(this.dataset.target);
                const icon = this.querySelector('i');
                if (target.type === 'password') {
                    target.type = 'text';
                    icon.classList.remove('fa-eye');
                    icon.classList.add('fa-eye-slash');
                } else {
                    target.type = 'password';
                    icon.classList.remove('fa-eye-slash');
                    icon.classList.add('fa-eye');
                }
            });
        });

        // Initialize tooltips
        $(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>
@endsection
