@extends('layouts.admin')

@section('content')
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle mr-2"></i>
            {{ session('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle mr-2"></i>
            {{ session('error') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <!-- Enhanced Header Section -->
    <div class="row mb-4">
        <div class="col-lg-8">
            <div class="d-flex align-items-center">
                <div class="mr-3">
                    <i class="fas fa-cog text-primary" style="font-size: 2rem;"></i>
                </div>
                <div>
                    <h2 class="mb-0 text-dark font-weight-bold">{{ trans('global.settings.title') }}</h2>
                    <p class="text-muted mb-0">Configure your application settings and preferences</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Enhanced Card Design -->
    <div class="card shadow-sm border-0">
        <div class="card-header bg-white border-0">
            <div class="d-flex align-items-center">
                <i class="fas fa-sliders-h text-primary mr-2"></i>
                <h5 class="mb-0 font-weight-bold">Application Settings</h5>
            </div>
        </div>

        <div class="card-body">
            <form id="settings-form" action="{{ route('admin.settings.update') }}" method="POST"
                enctype="multipart/form-data" class="needs-validation" novalidate>
                @csrf
                @method('PUT')

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="app_name" class="font-weight-bold">
                                {{ trans('global.settings.app_name') }}
                                <span class="text-danger">*</span>
                            </label>
                            <input type="text" class="form-control @error('app_name') is-invalid @enderror"
                                name="app_name" id="app_name" value="{{ old('app_name', $settings->app_name) }}"
                                placeholder="{{ trans('global.settings.default_app_name') }}" required>
                            @error('app_name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="form-text text-muted">
                                <i class="fas fa-info-circle mr-1"></i>
                                Default: {{ trans('global.settings.default_app_name') }}
                            </small>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="logo" class="font-weight-bold">
                                {{ trans('global.settings.logo') }}
                            </label>
                            <div class="custom-file">
                                <input type="file" class="custom-file-input @error('logo') is-invalid @enderror"
                                    name="logo" id="logo" accept="image/*">
                                <label class="custom-file-label" for="logo">Choose logo file...</label>
                            </div>
                            @error('logo')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror

                            @if ($settings->logo)
                                <div class="mt-3">
                                    <div class="d-flex align-items-center mb-2">
                                        <i class="fas fa-image text-info mr-2"></i>
                                        <small
                                            class="text-muted font-weight-bold">{{ trans('global.settings.current_logo') }}:</small>
                                    </div>
                                    <div class="border rounded p-3 bg-light">
                                        <img src="{{ app_logo() }}" alt="Current Logo" class="img-fluid"
                                            style="max-width: 150px; max-height: 100px; object-fit: contain;">
                                    </div>
                                    <div class="mt-2">
                                        <div class="custom-control custom-checkbox">
                                            <input type="checkbox" class="custom-control-input" name="remove_logo"
                                                value="1" id="remove_logo">
                                            <label class="custom-control-label text-danger" for="remove_logo">
                                                <i class="fas fa-trash mr-1"></i>
                                                {{ trans('global.settings.remove_logo') }}
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            @else
                                <div class="mt-2">
                                    <p class="text-muted">
                                        <i class="fas fa-exclamation-triangle mr-1"></i>
                                        {{ trans('global.settings.no_logo') }}
                                    </p>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="font-weight-bold">Currency Symbol</label>
                            <input type="text" class="form-control" name="currency_symbol"
                                value="{{ old('currency_symbol', $settings->currency_symbol) }}" required>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="font-weight-bold">Default Tax (%)</label>
                            <input type="number" step="0.01" min="0" max="100" class="form-control"
                                name="tax_percent" value="{{ old('tax_percent', $settings->tax_percent) }}">
                            <small class="form-text text-muted">
                                <i class="fas fa-info-circle mr-1"></i>
                                Default tax percentage applied to POS sales
                            </small>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="font-weight-bold">Default Discount (%)</label>
                            <input type="number" step="0.01" min="0" max="100" class="form-control"
                                name="discount_percent"
                                value="{{ old('discount_percent', $settings->discount_percent) }}">
                            <small class="form-text text-muted">
                                <i class="fas fa-info-circle mr-1"></i>
                                Default discount percentage applied to POS sales
                            </small>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="address" class="font-weight-bold">
                                {{ trans('global.settings.address') }}
                            </label>
                            <textarea class="form-control @error('address') is-invalid @enderror" name="address" id="address" rows="4"
                                placeholder="Enter your business address...">{{ old('address', $settings->address) }}</textarea>
                            @error('address')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="form-text text-muted">
                                <i class="fas fa-info-circle mr-1"></i>
                                This address will be used in invoices and reports
                            </small>
                        </div>
                    </div>
                </div>
            </form>
        </div>

        <div class="card-footer bg-light border-0">
            <div class="d-flex justify-content-between align-items-center">
                <div class="text-muted">
                    <i class="fas fa-shield-alt mr-1"></i>
                    Settings are automatically saved
                </div>
                <div>
                    <button type="submit" form="settings-form" class="btn btn-primary btn-lg shadow-sm">
                        <i class="fas fa-save mr-2"></i>
                        {{ trans('global.save') }} Settings
                    </button>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('styles')
    <style>
        .custom-file-label::after {
            content: "Browse";
        }

        .form-control:focus {
            border-color: #007bff;
            box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
        }

        .card {
            border-radius: 10px;
        }

        .card-header {
            border-radius: 10px 10px 0 0 !important;
        }
    </style>
@endsection

@section('scripts')
    <script>
        // Update custom file input label
        document.querySelector('#logo').addEventListener('change', function(e) {
            const fileName = e.target.files[0] ? e.target.files[0].name : 'Choose logo file...';
            e.target.nextElementSibling.textContent = fileName;
        });

        // Form validation
        (function() {
            'use strict';
            window.addEventListener('load', function() {
                var forms = document.getElementsByClassName('needs-validation');
                var validation = Array.prototype.filter.call(forms, function(form) {
                    form.addEventListener('submit', function(event) {
                        if (form.checkValidity() === false) {
                            event.preventDefault();
                            event.stopPropagation();
                        }
                        form.classList.add('was-validated');
                    }, false);
                });
            }, false);
        })();
    </script>
@endsection
