@extends('layouts.admin')
@section('content')
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-lg-8">
            <div class="d-flex align-items-center">
                <div class="mr-3">
                    <i class="fas fa-user-shield text-info" style="font-size: 2rem;"></i>
                </div>
                <div>
                    <h2 class="mb-0 text-dark font-weight-bold">
                        {{ trans('global.show') }} {{ trans('cruds.role.title') }}
                    </h2>
                    <p class="text-muted mb-0">View all permissions (assigned & unassigned) by module</p>
                </div>
            </div>
        </div>
        <div class="col-lg-4 text-right">
            <div class="btn-group">
                <a href="{{ route('admin.roles.index') }}" class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-left mr-2"></i>{{ trans('global.back_to_list') }}
                </a>
                @can('role_edit')
                    <a href="{{ route('admin.roles.edit', $role->id) }}" class="btn btn-primary">
                        <i class="fas fa-edit mr-2"></i>Edit
                    </a>
                @endcan
            </div>
        </div>
    </div>

    <!-- Role Info -->
    <div class="card shadow-sm border-0">
        <div class="card-header bg-white border-0">
            <div class="d-flex align-items-center">
                <i class="fas fa-id-badge text-primary mr-2"></i>
                <h5 class="mb-0 font-weight-bold">Role Details</h5>
            </div>
        </div>

        <div class="card-body">
            <div class="row">
                <div class="col-lg-8">
                    <table class="table table-borderless mb-4">
                        <tbody>
                            <tr>
                                <th class="text-muted font-weight-bold" style="width: 200px;">
                                    <i class="fas fa-hashtag mr-2"></i>ID
                                </th>
                                <td><span class="badge badge-secondary">{{ $role->id }}</span></td>
                            </tr>
                            <tr>
                                <th class="text-muted font-weight-bold">
                                    <i class="fas fa-user-shield mr-2"></i>Title
                                </th>
                                <td><strong>{{ $role->title }}</strong></td>
                            </tr>
                            <tr>
                                <th class="text-muted font-weight-bold">
                                    <i class="fas fa-key mr-2 text-primary"></i>Total Assigned Permissions
                                </th>
                                <td>
                                    <span class="badge badge-info">{{ $role->permissions->count() }}</span>
                                </td>


                            </tr>
                        </tbody>
                    </table>
                </div>

                <div class="col-lg-4">
                    <div class="card bg-light">
                        <div class="card-body text-center">
                            <div class="mb-3">
                                <i class="fas fa-shield-alt text-primary" style="font-size: 4rem;"></i>
                            </div>
                            <h5 class="card-title mb-1">{{ $role->title }}</h5>
                            <p class="card-text text-muted mb-3">Role ID: #{{ $role->id }}</p>
                            <hr>
                            <h6 class="text-muted mb-2">Total Assigned Permissions</h6>
                            <h5 class="text-primary mb-0">{{ $role->permissions->count() }}</h5>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Permissions Section -->
            <hr>
            <div class="mt-4">
                <h5 class="font-weight-bold text-dark mb-3">
                    <i class="fas fa-lock mr-2 text-primary"></i>All Permissions (Module-wise)
                </h5>

                @php
                    $allPermissions = \App\Models\Permission::all()->groupBy('module');
                    $rolePermissionIds = $role->permissions->pluck('id')->toArray();
                @endphp

                @if ($allPermissions->count() > 0)
                    <div class="row">
                        @foreach ($allPermissions as $module => $permissions)
                            <div class="col-md-6 col-lg-3 mb-4">
                                <div class="card border-0 shadow-sm h-100">
                                    <div class="card-header bg-primary text-white py-2">
                                        <h6 class="mb-0 text-center text-capitalize">
                                            <i class="fas fa-folder-open mr-1"></i>{{ $module ?? 'Other' }}
                                        </h6>
                                    </div>
                                    <div class="card-body">
                                        @foreach ($permissions as $permission)
                                            @php
                                                $hasPermission = in_array($permission->id, $rolePermissionIds);
                                            @endphp
                                            <div
                                                class="badge d-block mb-2 w-100 text-left text-capitalize p-2 {{ $hasPermission ? 'badge-info' : 'badge-light border text-muted' }}">
                                                <i
                                                    class="fas {{ $hasPermission ? 'fa-check-circle text-success' : 'fa-times-circle text-muted' }} mr-2"></i>
                                                {{ str_replace('_', ' ', $permission->title) }}
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="alert alert-light text-muted text-center mb-0">
                        <i class="fas fa-info-circle mr-1"></i>No permissions found.
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection
