<?php

namespace Database\Seeders;

use App\Models\Permission;
use Illuminate\Database\Seeder;

class PermissionsTableSeeder extends Seeder
{
    public function run()
    {
        $permissions = [
            // Dashboard
            ['module' => 'Dashboard', 'title' => 'dashboard_access'],

            // User Management
            ['module' => 'User Management', 'title' => 'user_management_access'],
            ['module' => 'User Management', 'title' => 'role_create'],
            ['module' => 'User Management', 'title' => 'role_edit'],
            ['module' => 'User Management', 'title' => 'role_show'],
            ['module' => 'User Management', 'title' => 'role_delete'],
            ['module' => 'User Management', 'title' => 'role_access'],
            ['module' => 'User Management', 'title' => 'user_create'],
            ['module' => 'User Management', 'title' => 'user_edit'],
            ['module' => 'User Management', 'title' => 'user_show'],
            ['module' => 'User Management', 'title' => 'user_delete'],
            ['module' => 'User Management', 'title' => 'user_access'],



            // Settings
            ['module' => 'Settings', 'title' => 'settings_access'],

            // Profile
            ['module' => 'Profile', 'title' => 'profile_password_edit'],
        ];

        foreach ($permissions as $permission) {
            Permission::updateOrCreate(
                ['title' => $permission['title']],
                ['module' => $permission['module']]
            );
        }
    }
}