<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('videos', function (Blueprint $table) {
            $table->enum('video_type', ['link', 'upload'])->default('link')->after('title');
            $table->string('video_path')->nullable()->after('video_type');
            $table->string('url')->nullable()->change();
            $table->integer('sort_order')->default(0)->after('video_path');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('videos', function (Blueprint $table) {
            $table->dropColumn(['video_type', 'video_path']);
        });
    }
};
