<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\Controller;
use App\Mail\ContactFormSubmission;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class ContactController extends Controller
{
    public function submit(Request $request)
    {
        $validated = $request->validate([
            'name'    => 'required|string|max:255',
            'email'   => 'required|email|max:255',
            'phone'   => 'nullable|string|max:20',
            'service' => 'nullable|string|max:50',
            'message' => 'required|string|max:5000',
        ]);

        try {
    
            Mail::to('info@blueweldsg.com')->send(new ContactFormSubmission($validated));

            return response()->json([
                'status'  => 'success',
                'message' => 'Thank you for your message! We will get back to you soon.'
            ]);
        } catch (\Exception $e) {

            return response()->json([
                'status'  => 'error',
                'message' => 'Sorry, something went wrong while sending your message. Please try again later.'
            ], 500);
        }
    }
}
